/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record OpenActionDataEntryEditorMessage(UUID uuid, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, ActionEventType actionEventType, ConfigurationType configurationType, EditorType editorType) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"open_action_data_entry_editor");
    public static final CustomPacketPayload.Type<OpenActionDataEntryEditorMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenActionDataEntryEditorMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), OpenActionDataEntryEditorMessage::create);

    public static OpenActionDataEntryEditorMessage create(FriendlyByteBuf buffer) {
        return new OpenActionDataEntryEditorMessage(buffer.readUUID(), buffer.readUUID(), buffer.readUUID(), buffer.readUUID(), (ActionEventType)buffer.readEnum(ActionEventType.class), (ConfigurationType)buffer.readEnum(ConfigurationType.class), (EditorType)buffer.readEnum(EditorType.class));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.dialogId);
        buffer.writeUUID(this.dialogButtonId);
        buffer.writeUUID(this.actionDataEntryId);
        buffer.writeEnum((Enum)this.actionEventType);
        buffer.writeEnum((Enum)this.configurationType);
        buffer.writeEnum((Enum)this.editorType);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        MenuManager.getMenuHandler().openEditorMenu(EditorType.ACTION_DATA_ENTRY, serverPlayer, easyNPC, this.dialogId, this.dialogButtonId, this.actionDataEntryId, this.actionEventType, this.configurationType, this.editorType, 0);
    }
}

