/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.sound.SoundDataEntry;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface SoundData<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final String EASY_NPC_DATA_SOUND_DATA_TAG = "SoundData";

    public static void registerSyncedSoundData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Sound Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.SOUND_DATA_SET, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.SOUND_DATA_SET));
    }

    default public SoundDataSet getSoundDataSet() {
        return (SoundDataSet)this.getSynchedEntityData(SynchedDataIndex.SOUND_DATA_SET);
    }

    default public void setSoundDataSet(SoundDataSet soundDataSet) {
        this.setSynchedEntityData(SynchedDataIndex.SOUND_DATA_SET, soundDataSet);
    }

    default public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        return soundDataSet;
    }

    default public void refreshSoundDataSet() {
        SoundDataSet soundDataSet = this.getSoundDataSet();
        if (soundDataSet == null || soundDataSet.isEmpty()) {
            this.clearSoundDataSet();
            this.setSoundDataSet(soundDataSet);
        }
    }

    default public void clearSoundDataSet() {
        this.setSoundDataSet(new SoundDataSet());
    }

    default public boolean hasDefaultSound(SoundType soundType) {
        return this.getSoundDataSet().hasSound(soundType);
    }

    default public SoundDataEntry getDefaultSound(SoundType soundType) {
        return this.getSoundDataSet().getSound(soundType);
    }

    default public SoundEvent getDefaultSoundEvent(SoundType soundType) {
        if (!this.hasDefaultSound(soundType)) {
            return null;
        }
        return this.getDefaultSound(soundType).getSoundEvent();
    }

    default public void playDefaultTradeUpdatedSound(boolean yesSound) {
        if (yesSound) {
            this.playDefaultSound(SoundType.TRADE_YES);
        } else {
            this.playDefaultSound(SoundType.TRADE_NO);
        }
    }

    default public void playDefaultAmbientSound() {
        OwnerData ownerData = this.getEasyNPCOwnerData();
        if (ownerData != null && ownerData.hasOwner()) {
            if (this.hasDefaultSound(SoundType.AMBIENT_TAMED) && EasyNPC.randomNumber.nextInt(4) == 0) {
                this.playDefaultSound(SoundType.AMBIENT_TAMED);
                return;
            }
            if (this.hasDefaultSound(SoundType.AMBIENT)) {
                this.playDefaultSound(SoundType.AMBIENT);
                return;
            }
        }
        if (this.hasDefaultSound(SoundType.AMBIENT_STRAY)) {
            this.playDefaultSound(SoundType.AMBIENT_STRAY);
        } else {
            this.playDefaultSound(SoundType.AMBIENT);
        }
    }

    default public void playDefaultHurtSound(DamageSource damageSource) {
        this.playDefaultSound(SoundType.HURT);
    }

    default public void playDefaultStepSound(BlockPos blockPos, BlockState blockState) {
        this.playDefaultSound(SoundType.STEP);
    }

    default public void playDefaultSound(SoundType soundType) {
        SoundEvent soundEvent;
        Level level = this.getLevel();
        Entity entity = this.getEntity();
        if (soundType == null || level == null || entity == null || entity.isSilent() || !this.hasDefaultSound(soundType)) {
            return;
        }
        SoundDataEntry soundDataEntry = this.getDefaultSound(soundType);
        if (soundDataEntry.isEnabled() && soundDataEntry.getVolume() > 0.0f && (soundEvent = soundDataEntry.getSoundEvent()) != null) {
            entity.playSound(soundEvent, soundDataEntry.getVolume(), soundDataEntry.getPitch() + (EasyNPC.randomNumber.nextFloat() - EasyNPC.randomNumber.nextFloat()) * 0.3f);
        }
    }

    default public SoundEvent getDefaultDeathSound() {
        return this.getDefaultSoundEvent(SoundType.DEATH);
    }

    default public void defineSynchedSoundData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.SOUND_DATA_SET, new SoundDataSet());
    }

    default public void registerDefaultSoundData(Enum<?> variant) {
        SoundDataSet soundDataSet = this.getSoundDataSet();
        if (soundDataSet == null || soundDataSet.isEmpty()) {
            this.setSoundDataSet(this.getDefaultSoundDataSet(new SoundDataSet(), variant.name()));
        }
    }

    default public void addAdditionalSoundData(CompoundTag compoundTag) {
        CompoundTag soundDataTag = new CompoundTag();
        SoundDataSet soundDataSet = this.getSoundDataSet();
        if (soundDataSet != null && !soundDataSet.isEmpty()) {
            soundDataSet.save(soundDataTag);
        } else {
            VariantData variantData = this.getEasyNPCVariantData();
            SoundDataSet defaultSoundDataSet = this.getDefaultSoundDataSet(new SoundDataSet(), variantData != null ? variantData.getVariant().name() : "");
            defaultSoundDataSet.save(soundDataTag);
        }
        compoundTag.put(EASY_NPC_DATA_SOUND_DATA_TAG, (Tag)soundDataTag);
    }

    default public void readAdditionalSoundData(CompoundTag compoundTag) {
        if (!compoundTag.contains(EASY_NPC_DATA_SOUND_DATA_TAG)) {
            return;
        }
        CompoundTag soundDataTag = compoundTag.getCompound(EASY_NPC_DATA_SOUND_DATA_TAG);
        if (soundDataTag.contains("SoundDataSet")) {
            SoundDataSet soundDataSet = new SoundDataSet(soundDataTag);
            this.setSoundDataSet(soundDataSet);
        }
    }
}

