/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;

public interface PresetData<T extends PathfinderMob>
extends EasyNPC<T> {
    default public CompoundTag exportPresetData() {
        CompoundTag compoundTag = this.serializePresetData();
        if (compoundTag.contains("SpawnerUUID")) {
            compoundTag.remove("SpawnerUUID");
        }
        return compoundTag;
    }

    default public void importPresetData(CompoundTag compoundTag) {
        if (compoundTag == null || compoundTag.isEmpty() || this.getEntity() == null) {
            return;
        }
        if (this.getEntity() != null) {
            this.getEntity().setPose(Pose.STANDING);
        }
        if (this.getEasyNPCModelData() != null) {
            this.getEasyNPCModelData().setModelPose(ModelPose.DEFAULT);
        }
        if (this.getEasyNPCActionEventData() != null) {
            this.getEasyNPCActionEventData().clearActionEventSet();
        }
        if (this.getEasyNPCDialogData() != null) {
            this.getEasyNPCDialogData().clearDialogDataSet();
        }
        if (!compoundTag.contains("UUID") || !compoundTag.contains("Pos")) {
            CompoundTag existingCompoundTag = this.serializePresetData();
            if (existingCompoundTag.contains("DialogData")) {
                existingCompoundTag.remove("DialogData");
            }
            if (existingCompoundTag.contains("ModelData")) {
                existingCompoundTag.remove("ModelData");
            }
            if (existingCompoundTag.contains("SkinData")) {
                existingCompoundTag.remove("SkinData");
            }
            if (existingCompoundTag.contains("RenderData")) {
                existingCompoundTag.remove("RenderData");
            }
            if (existingCompoundTag.contains("ActionData")) {
                existingCompoundTag.remove("ActionData");
            }
            log.debug("Merging preset {} with existing data {} for {}", (Object)compoundTag, (Object)existingCompoundTag, (Object)this);
            compoundTag = existingCompoundTag.merge(compoundTag);
        } else {
            log.debug("Importing full preset {} for {}", (Object)compoundTag, (Object)this);
        }
        if (compoundTag.contains("Motion")) {
            compoundTag.remove("Motion");
        }
        this.getEntity().load(compoundTag);
    }

    default public CompoundTag serializePresetData() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.getEntity() == null) {
            return compoundTag;
        }
        String entityTypeId = this.getEntityTypeId();
        if (entityTypeId != null) {
            compoundTag.putString("id", entityTypeId);
        }
        return this.getEntity().saveWithoutId(compoundTag);
    }
}

