/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.PathfinderMob;

public interface DialogData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final ServerDataAccessor<DialogDataSet> CUSTOM_DATA_DIALOG_DATA_SET = ServerEntityData.defineId(ServerDataIndex.DIALOG_DATA_SET, EntityDataSerializersManager.DIALOG_DATA_SET);
    public static final String DATA_DIALOG_DATA_TAG = "DialogData";

    default public int getEntityDialogTop() {
        return 0;
    }

    default public int getEntityDialogLeft() {
        return 0;
    }

    default public int getEntityDialogScaling() {
        return 50;
    }

    default public DialogDataSet getDialogDataSet() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_DIALOG_DATA_SET);
    }

    default public void setDialogDataSet(DialogDataSet dialogDataSet) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_DIALOG_DATA_SET, dialogDataSet);
    }

    default public void clearDialogDataSet() {
        this.setDialogDataSet(new DialogDataSet());
    }

    default public boolean hasDialog() {
        return this.getDialogDataSet().hasDialog();
    }

    default public boolean hasDialog(String dialogLabel) {
        return this.getDialogDataSet().hasDialog(dialogLabel);
    }

    default public boolean hasDialog(UUID dialogId) {
        return this.getDialogDataSet().hasDialog(dialogId);
    }

    default public boolean removeDialog(UUID dialogId) {
        return this.getDialogDataSet().removeDialog(dialogId);
    }

    default public boolean removeDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.getDialogDataSet().removeDialogButton(dialogId, dialogButtonId);
    }

    default public void setDialog(UUID dialogId, DialogDataEntry dialogData) {
        this.getDialogDataSet().setDialog(dialogId, dialogData);
    }

    default public UUID getDialogId(String dialogLabel) {
        return this.getDialogDataSet().getDialogId(dialogLabel);
    }

    default public boolean hasDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.getDialogDataSet().hasDialogButton(dialogId, dialogButtonId);
    }

    default public void openDialog(ServerPlayer serverPlayer, UUID dialogId) {
        MenuManager.getMenuHandler().openDialogMenu(serverPlayer, this, dialogId, 0);
    }

    default public void openDefaultDialog(ServerPlayer serverPlayer) {
        UUID uuid = this.getDialogDataSet().getDefaultDialogId();
        if (uuid != null) {
            this.openDialog(serverPlayer, uuid);
        }
    }

    default public DialogButtonEntry getDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.getDialogDataSet().getDialogButton(dialogId, dialogButtonId);
    }

    default public void defineSynchedDialogData(SynchedEntityData.Builder builder) {
    }

    default public void defineCustomDialogData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_DIALOG_DATA_SET, new DialogDataSet());
    }

    default public void addAdditionalDialogData(CompoundTag compoundTag) {
        DialogDataSet dialogDataSet;
        CompoundTag dialogDataTag = new CompoundTag();
        if (this.isServerSide() && (dialogDataSet = this.getDialogDataSet()) != null) {
            dialogDataSet.save(dialogDataTag);
        }
        compoundTag.put(DATA_DIALOG_DATA_TAG, (Tag)dialogDataTag);
    }

    default public void readAdditionalDialogData(CompoundTag compoundTag) {
        if (!compoundTag.contains(DATA_DIALOG_DATA_TAG)) {
            return;
        }
        CompoundTag dialogDataTag = compoundTag.getCompound(DATA_DIALOG_DATA_TAG);
        if (dialogDataTag.contains("DialogDataSet")) {
            DialogDataSet dialogDataSet = new DialogDataSet(dialogDataTag);
            this.setDialogDataSet(dialogDataSet);
        }
    }
}

