/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.rotation;

import java.util.List;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record CustomRotation(float x, float y, float z) {
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomRotation> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CustomRotation>(){

        public CustomRotation decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new CustomRotation(registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, CustomRotation rotation) {
            registryFriendlyByteBuf.writeFloat(rotation.x);
            registryFriendlyByteBuf.writeFloat(rotation.y);
            registryFriendlyByteBuf.writeFloat(rotation.z);
        }
    };

    public CustomRotation(ListTag listTag) {
        this(listTag.getFloat(0), listTag.getFloat(1), listTag.getFloat(2));
    }

    public CustomRotation(List<Float> list) {
        this(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue());
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.valueOf((float)this.x));
        listTag.add((Object)FloatTag.valueOf((float)this.y));
        listTag.add((Object)FloatTag.valueOf((float)this.z));
        return listTag;
    }

    public boolean hasChanged() {
        return this.hasChanged(0.0f, 0.0f, 0.0f);
    }

    public boolean hasChanged(float x, float y, float z) {
        return this.x != x || this.y != y || this.z != z;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CustomRotation)) return false;
        CustomRotation customRotation = (CustomRotation)object;
        if (this.x != customRotation.x) return false;
        if (this.y != customRotation.y) return false;
        if (this.z != customRotation.z) return false;
        return true;
    }
}

