/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.editor;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public enum EditorType {
    NONE,
    ACTION_DATA,
    ACTION_DATA_ENTRY,
    DIALOG,
    DIALOG_BUTTON,
    DIALOG_TEXT;


    public static EditorType get(String editorType) {
        if (editorType == null || editorType.isEmpty()) {
            return NONE;
        }
        try {
            return EditorType.valueOf(editorType);
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }

    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)(this.name().toLowerCase(Locale.ROOT) + "_editor"));
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT) + "_editor";
    }

    public Component getEditorTitle(EasyNPC<?> easyNPC) {
        String translationKey = "text.easy_npc.config." + this.name().toLowerCase(Locale.ROOT) + ".title";
        return TextComponent.getTranslatedTextRaw(translationKey, easyNPC.getEntity().getName().getString(20));
    }
}

