/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.configuration;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;

public class ConfigurationTypeHelper {
    private ConfigurationTypeHelper() {
    }

    public static ConfigurationType resolveConfigurationTypeAlias(ConfigurationType configurationType, EasyNPC<?> easyNPC) {
        if (!configurationType.isAlias()) {
            return configurationType;
        }
        if (configurationType == ConfigurationType.DIALOG) {
            DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
            if (dialogData != null && dialogData.getDialogDataSet() != null) {
                return switch (dialogData.getDialogDataSet().getType()) {
                    case DialogType.NONE -> ConfigurationType.NONE_DIALOG;
                    case DialogType.YES_NO -> ConfigurationType.YES_NO_DIALOG;
                    case DialogType.CUSTOM, DialogType.STANDARD -> ConfigurationType.ADVANCED_DIALOG;
                    default -> ConfigurationType.BASIC_DIALOG;
                };
            }
        } else {
            if (configurationType == ConfigurationType.SKIN) {
                SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
                return switch (skinData.getSkinType()) {
                    case SkinType.NONE -> ConfigurationType.NONE_SKIN;
                    case SkinType.PLAYER_SKIN -> ConfigurationType.PLAYER_SKIN;
                    case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> ConfigurationType.URL_SKIN;
                    case SkinType.CUSTOM -> ConfigurationType.CUSTOM_SKIN;
                    default -> ConfigurationType.DEFAULT_SKIN;
                };
            }
            if (configurationType == ConfigurationType.TRADING) {
                TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
                return switch (tradingData.getTradingDataSet().getType()) {
                    case TradingType.ADVANCED -> ConfigurationType.ADVANCED_TRADING;
                    case TradingType.BASIC -> ConfigurationType.BASIC_TRADING;
                    case TradingType.CUSTOM -> ConfigurationType.CUSTOM_TRADING;
                    default -> ConfigurationType.NONE_TRADING;
                };
            }
            if (configurationType == ConfigurationType.POSE) {
                ModelData<?> modelData = easyNPC.getEasyNPCModelData();
                return switch (modelData.getModelPose()) {
                    case ModelPose.CUSTOM -> {
                        if (modelData.hasChangedModelPosition()) {
                            yield ConfigurationType.CUSTOM_POSE;
                        }
                        yield ConfigurationType.ADVANCED_POSE;
                    }
                    default -> ConfigurationType.DEFAULT_POSE;
                };
            }
        }
        return configurationType;
    }
}

