/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import java.util.Locale;

public enum ActionDataType {
    NONE,
    COMMAND,
    CLOSE_DIALOG(false),
    INTERACT_BLOCK,
    OPEN_TRADING_SCREEN(false),
    OPEN_DEFAULT_DIALOG(false),
    OPEN_NAMED_DIALOG;

    private final boolean requiresArgument;

    private ActionDataType() {
        this.requiresArgument = true;
    }

    private ActionDataType(boolean requiresArgument) {
        this.requiresArgument = requiresArgument;
    }

    public static ActionDataType get(String actionType) {
        if (actionType == null || actionType.isEmpty()) {
            return NONE;
        }
        try {
            return ActionDataType.valueOf(actionType);
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }

    public boolean requiresArgument() {
        return this.requiresArgument;
    }

    public String getId() {
        return "actionDataType." + this.name().toLowerCase(Locale.ROOT);
    }
}

