/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import de.markusbordihn.easynpc.validator.ImageValidator;
import de.markusbordihn.easynpc.validator.UrlValidator;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class UrlSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_DELAY = 20;
    protected Button addTextureSettingsButton = null;
    protected EditBox textureSkinLocationBox;
    private boolean canTextureSkinLocationChange = true;
    private Button clearTextureSettingsButton = null;
    private String formerTextureSkinLocation = "";
    private String errorMessage = "";

    public UrlSkinConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private static void updateNextTextureSkinLocationChange() {
        nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond() + 20;
    }

    private void renderSkins(GuiGraphics guiGraphics) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        Set<UUID> textures = RemoteTextureManager.getTextureCacheKeys(skinModel);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(guiGraphics, left, top, skinModel, textureKey);
            int topNamePos = Math.round((float)(top - 76) / 0.7f);
            int leftNamePos = Math.round((float)(left - 21) / 0.7f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            guiGraphics.pose().scale(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(textureKey.toString(), 11);
            Text.drawString(guiGraphics, this.font, variantName, leftNamePos, topNamePos, 43520);
            guiGraphics.pose().popPose();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(GuiGraphics guiGraphics, int x, int y, SkinModel skinModel, UUID textureUUID) {
        TextureModelKey textureModelKey = new TextureModelKey(textureUUID, skinModel);
        SkinType skinType = RemoteTextureManager.getTextureSkinType(textureModelKey);
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> {
            String skinURL = RemoteTextureManager.getTextureSkinURL(textureModelKey);
            NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), "", skinURL, textureUUID, skinType, "");
        });
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        UUID skinUUID = skinData.getSkinUUID();
        skinButton.active = !skinUUID.equals(textureUUID);
        ScreenHelper.renderEntityCustomSkin(guiGraphics, x + 4, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.getEasyNPC(), textureUUID, skinType);
        this.skinButtons.add(skinButton);
    }

    private void clearTextureSkinLocation() {
        if (!this.textureSkinLocationBox.getValue().isEmpty()) {
            this.textureSkinLocationBox.setValue("");
        }
    }

    private void addTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.getValue();
        if (!textureSkinLocationValue.isEmpty() && !textureSkinLocationValue.equals(this.formerTextureSkinLocation)) {
            URL textureSkinLocation;
            if (!UrlValidator.isValidUrl(textureSkinLocationValue)) {
                this.errorMessage = "invalid_remote_image";
                return;
            }
            try {
                textureSkinLocation = new URL(textureSkinLocationValue);
            }
            catch (Exception e) {
                return;
            }
            if (!ImageValidator.isValidImage(textureSkinLocation)) {
                log.error("Unable to set remote user texture to {}", (Object)textureSkinLocationValue);
                this.errorMessage = "invalid_remote_image";
                return;
            }
            log.debug("Setting remote user texture to {}", (Object)textureSkinLocationValue);
            TextureManager.clearLastErrorMessage();
            this.errorMessage = "";
            NetworkMessageHandlerManager.getServerHandler().setRemoteSkin(this.getEasyNPCUUID(), textureSkinLocationValue);
            this.addTextureSettingsButton.active = false;
            this.formerTextureSkinLocation = textureSkinLocationValue;
            UrlSkinConfigurationScreen.updateNextTextureSkinLocationChange();
        }
    }

    private void validateTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.getValue();
        if (!this.canTextureSkinLocationChange) {
            this.addTextureSettingsButton.active = false;
            this.clearTextureSettingsButton.active = true;
            return;
        }
        this.addTextureSettingsButton.active = !textureSkinLocationValue.isEmpty() && UrlValidator.isValidUrl(textureSkinLocationValue);
        this.clearTextureSettingsButton.active = !textureSkinLocationValue.isEmpty();
    }

    @Override
    public void init() {
        super.init();
        this.urlSkinButton.active = false;
        this.setDescriptionText("url_skin.text");
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        this.numOfSkins = RemoteTextureManager.getTextureCacheKeys(skinModel).size();
        this.textureSkinLocationBox = new TextField(this.font, this.contentLeftPos, this.contentTopPos + 50, 180);
        this.textureSkinLocationBox.setMaxLength(255);
        this.textureSkinLocationBox.setValue("");
        this.textureSkinLocationBox.setResponder(consumer -> this.validateTextureSkinLocation());
        this.addRenderableWidget((GuiEventListener)this.textureSkinLocationBox);
        this.addTextureSettingsButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.textureSkinLocationBox.getX() + this.textureSkinLocationBox.getWidth() + 2, this.contentTopPos + 50, 65, "add", onPress -> this.addTextureSkinLocation()));
        this.addTextureSettingsButton.active = false;
        this.clearTextureSettingsButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.addTextureSettingsButton.getX() + this.addTextureSettingsButton.getWidth() + 1, this.contentTopPos + 50, 55, "clear", onPress -> this.clearTextureSkinLocation()));
        this.clearTextureSettingsButton.active = false;
        this.defineSkinNavigationButtons();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 5);
        if (this.addTextureSettingsButton != null) {
            Text.drawConfigString(guiGraphics, this.font, "use_a_skin_url", this.contentLeftPos, this.addTextureSettingsButton.getY() - 10);
        }
        boolean bl = this.canTextureSkinLocationChange = Instant.now().getEpochSecond() >= (long)nextTextureSkinLocationChange;
        if (!this.canTextureSkinLocationChange) {
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            Graphics.blit(guiGraphics, Constants.TEXTURE_CONFIGURATION, this.leftPos + 176, this.contentTopPos + 53, 82, 1, 8, 10);
            if (!TextureManager.hasLastErrorMessage() && this.errorMessage.isEmpty()) {
                Text.drawConfigString(guiGraphics, this.font, "processing_url_skin", this.leftPos + 55, this.contentTopPos + 80);
            }
        }
        if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
            Text.drawErrorMessage(guiGraphics, this.font, (Component)TextComponent.getTranslatedText(this.errorMessage), this.leftPos + 10, this.contentTopPos + 71, this.imageWidth - 14);
        } else if (TextureManager.hasLastErrorMessage()) {
            Text.drawErrorMessage(guiGraphics, this.font, TextureManager.getLastErrorMessage(), this.leftPos + 10, this.contentTopPos + 71, this.imageWidth - 14);
        }
        this.renderSkins(guiGraphics);
    }
}

