/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.preset;

import de.markusbordihn.easynpc.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ImportDefaultPresetConfigurationScreen<T extends ConfigurationMenu>
extends ImportPresetConfigurationScreen<T> {
    private final Set<ResourceLocation> defaultPresets;

    public ImportDefaultPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.importPresetButtonLabel = "import_default_preset";
        this.importPresetHeaderLabel = "preset_default_for";
        this.defaultPresets = CompoundTagUtils.readResourceLocations(this.getAdditionalScreenData().getList("DefaultPresets")).stream().filter(resourceLocation -> resourceLocation.getPath().contains("/" + this.getSkinModel().getName() + "/")).collect(Collectors.toSet());
    }

    @Override
    public void loadPreset(ResourceLocation resourceLocation) {
        NetworkMessageHandlerManager.getServerHandler().importDefaultPreset(this.getEasyNPCUUID(), resourceLocation);
    }

    @Override
    public void init() {
        super.init();
        this.defaultImportPresetButton.active = false;
        ImportDefaultPresetConfigurationScreen.updatePresets(this.defaultPresets.stream().toList());
        this.presetSelectionList.updatePresets();
    }
}

