/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.base;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.entity.EasyNPCBaseEntity;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;

public class BaseMobModelRenderer<E extends EasyNPCBaseModelEntity<E>, V, M extends EntityModel<E>>
extends MobRenderer<E, M>
implements EasyNPCModelRenderer<E, M> {
    protected final Map<V, ResourceLocation> textures;
    protected final Map<V, ResourceLocation> texturesOverlay;
    protected final ResourceLocation defaultTexture;

    public BaseMobModelRenderer(EntityRendererProvider.Context context, M model, float shadowRadius, ResourceLocation defaultTexture) {
        this(context, model, shadowRadius, defaultTexture, null, null);
    }

    public BaseMobModelRenderer(EntityRendererProvider.Context context, M model, float shadowRadius, ResourceLocation defaultTexture, Map<V, ResourceLocation> textures) {
        this(context, model, shadowRadius, defaultTexture, textures, null);
    }

    public BaseMobModelRenderer(EntityRendererProvider.Context context, M model, float shadowRadius, ResourceLocation defaultTexture, Map<V, ResourceLocation> textures, Map<V, ResourceLocation> texturesOverlay) {
        super(context, model, shadowRadius);
        this.defaultTexture = defaultTexture != null ? defaultTexture : Constants.BLANK_ENTITY_TEXTURE;
        this.textures = textures;
        this.texturesOverlay = texturesOverlay;
    }

    public ResourceLocation getTextureLocation(E entity) {
        return this.getEntityTexture((EasyNPC)entity);
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return this.defaultTexture;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variant) {
        return this.textures != null ? this.textures.getOrDefault(variant, this.defaultTexture) : Constants.BLANK_ENTITY_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureOverlayByVariant(Enum<?> variant) {
        return this.texturesOverlay != null ? this.texturesOverlay.getOrDefault(variant, Constants.BLANK_ENTITY_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }

    protected void scale(E entity, PoseStack poseStack, float unused) {
        EasyNPCModelRenderer.scaleEntity(entity, poseStack);
    }

    protected void renderNameTag(E entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int color, float rotation) {
        EasyNPCModelRenderer.renderEntityNameTag(entity, poseStack);
        super.renderNameTag(entity, component, poseStack, multiBufferSource, color, rotation);
    }

    protected int getBlockLightLevel(E entity, BlockPos blockPos) {
        return EasyNPCModelRenderer.getEntityLightLevel(entity, blockPos);
    }

    public void render(E entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean isVisibleToPlayer;
        Minecraft minecraft = Minecraft.getInstance();
        boolean isVisible = !((EasyNPCBaseEntity)entity).isInvisible();
        boolean bl = isVisibleToPlayer = !((EasyNPCBaseEntity)entity).isInvisibleTo((Player)minecraft.player);
        if (!isVisible || !isVisibleToPlayer) {
            return;
        }
        this.renderModel((EasyNPCBaseModelEntity)entity, this.getModel(), entityYaw, partialTicks, poseStack, buffer, packedLight);
        if (!this.renderEntity((PathfinderMob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight)) {
            super.render(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public boolean shouldRender(E entity, Frustum frustum, double x, double y, double z) {
        if (!((EasyNPCBaseEntity)entity).isInvisible() && !((EasyNPCBaseEntity)entity).isInvisibleTo((Player)Minecraft.getInstance().player)) {
            return super.shouldRender(entity, frustum, x, y, z);
        }
        return false;
    }
}

