/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidLegAnimation;
import de.markusbordihn.easynpc.client.model.base.BaseHierarchicalArmHeadModel;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class StandardIllagerModel<T extends Mob>
extends BaseHierarchicalArmHeadModel<T> {
    private final ModelPart arms;

    public StandardIllagerModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart hat = this.head.getChild("hat");
        hat.visible = false;
        this.arms = this.defineModelPart(ModelPartType.ARMS, modelPart, "arms");
    }

    @Override
    public void resetModelParts() {
        super.resetModelParts();
        this.resetModelPart(ModelPartType.ARMS, this.arms);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean isCrossedArms;
        if (!(entity instanceof EasyNPC)) {
            return;
        }
        EasyNPC easyNPC = (EasyNPC)entity;
        this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ModelData modelData = easyNPC.getEasyNPCModelData();
        VariantData variantData = easyNPC.getEasyNPCVariantData();
        this.arms.visible = isCrossedArms = (modelData.getModelArmPose() == ModelArmPose.CROSSED || variantData.hasVariantCrossedArms()) && !AttackHandler.isHoldingWeapon(entity);
        this.leftArm.visible = !isCrossedArms;
        this.rightArm.visible = !isCrossedArms;
    }

    @Override
    public boolean animateModelLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidLegAnimation.animateHumanoidModelLegs(rightLegPart, leftLegPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.xRot = 0.5f;
        this.body.y = 3.2f;
        this.head.y = 4.2f;
        if (this.arms.visible) {
            this.arms.xRot += 0.4f;
            this.arms.y = 5.2f;
        }
        if (this.leftArm.visible) {
            this.leftArm.xRot += 0.4f;
            this.leftArm.y = 5.2f;
        }
        this.leftLeg.y = 12.2f;
        this.leftLeg.z = 4.0f;
        if (this.rightArm.visible) {
            this.rightArm.xRot += 0.4f;
            this.rightArm.y = 5.2f;
        }
        this.rightLeg.y = 12.2f;
        this.rightLeg.z = 4.0f;
        return true;
    }
}

