/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;

public class StandardCatModel<T extends Entity>
extends OcelotModel<T>
implements EasyNPCModel<T>,
HeadedModel {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, Boolean> modelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);

    public StandardCatModel(ModelPart modelPart) {
        super(modelPart);
        this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.defineModelPart(ModelPartType.RIGHT_HIND_LEG, modelPart, "right_hind_leg");
        this.defineModelPart(ModelPartType.LEFT_HIND_LEG, modelPart, "left_hind_leg");
        this.defineModelPart(ModelPartType.RIGHT_FRONT_LEG, modelPart, "right_front_leg");
        this.defineModelPart(ModelPartType.LEFT_FRONT_LEG, modelPart, "left_front_leg");
        this.defineModelPart(ModelPartType.TAIL1, modelPart, "tail1");
        this.defineModelPart(ModelPartType.TAIL2, modelPart, "tail2");
    }

    public ModelPart getHead() {
        return this.head;
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_HIND_LEG, this.rightHindLeg);
        this.resetModelPart(ModelPartType.LEFT_HIND_LEG, this.leftHindLeg);
        this.resetModelPart(ModelPartType.RIGHT_FRONT_LEG, this.rightFrontLeg);
        this.resetModelPart(ModelPartType.LEFT_FRONT_LEG, this.leftFrontLeg);
        this.resetModelPart(ModelPartType.TAIL1, this.tail1);
        this.resetModelPart(ModelPartType.TAIL2, this.tail2);
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, ModelPart> getModelPartMap() {
        return this.modelPartMap;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    public void adjustDefaultModelParts(T entity, EasyNPC<?> easyNPC) {
        this.tail1.x = this.body.x;
        this.tail1.y = this.body.y + 3.0f;
        this.tail1.z = this.body.z + 18.0f;
        this.tail2.x = this.tail1.x;
        this.tail2.y = this.tail1.y + 5.0f;
        this.tail2.z = this.tail1.z + 6.0f;
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftFrontLeg, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightFrontLeg, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftHindLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightHindLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.modelPartPositionMap.put(modelPartType, customPosition);
    }

    @Override
    public void setDefaultModelPartRotation(ModelPartType modelPartType, CustomRotation rotation) {
        this.modelPartRotationMap.put(modelPartType, rotation);
    }

    @Override
    public void setDefaultModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.modelPartMap.put(modelPartType, modelPart);
    }

    @Override
    public CustomPosition getDefaultModelPartPosition(ModelPartType modelPartType) {
        return this.modelPartPositionMap.getOrDefault((Object)modelPartType, EMPTY_POSITION);
    }

    @Override
    public CustomRotation getDefaultModelPartRotation(ModelPartType modelPartType) {
        return this.modelPartRotationMap.getOrDefault((Object)modelPartType, EMPTY_ROTATION);
    }

    @Override
    public Map<ModelPartType, Boolean> getModelPartVisibilityMap() {
        return this.modelPartVisibilityMap;
    }

    @Override
    public ModelPart getDefaultModelPart(ModelPartType modelPartType) {
        return this.modelPartMap.getOrDefault((Object)modelPartType, null);
    }
}

