/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.base.BaseHierarchicalArmModel;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class StandardAllayModel<T extends Mob>
extends BaseHierarchicalArmModel<T> {
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public StandardAllayModel(ModelPart modelPart) {
        super(modelPart);
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition rootDefinition = partDefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)23.5f, (float)0.0f));
        rootDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.99f, (float)0.0f));
        PartDefinition bodyDefinition = rootDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        bodyDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(23, 0).addBox(-0.75f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)-1.75f, (float)0.5f, (float)0.0f));
        bodyDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(23, 6).addBox(-0.25f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)1.75f, (float)0.5f, (float)0.0f));
        bodyDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)0.0f, (float)0.6f));
        bodyDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)0.0f, (float)0.6f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.xRot = 0.5f;
        this.body.y += 1.2f;
        this.head.y += 2.2f;
        this.leftArm.xRot += 0.4f;
        this.leftArm.y = 2.2f;
        this.rightArm.xRot += 0.4f;
        this.rightArm.y = 2.2f;
        return true;
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPosition(this.root, 0.0f, 18.0f, 0.0f);
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public boolean animateModelArms(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightArmPart == null || leftArmPart == null) {
            return false;
        }
        float ageAmount = ageInTicks * 9.0f * ((float)Math.PI / 180);
        float armRotationAmount = 0.43633232f - Mth.cos((float)(ageAmount + 4.712389f)) * (float)Math.PI * 0.075f * 1.0f - limbSwingAmount;
        this.leftArm.xRot = this.rightArm.xRot = Mth.lerp((float)1.0f, (float)(limbSwingAmount * 0.6981317f), (float)Mth.lerp((float)limbSwingAmount, (float)-1.0471976f, (float)-0.7853982f));
        this.leftArm.zRot = -armRotationAmount;
        this.rightArm.zRot = armRotationAmount;
        this.rightArm.yRot = 0.27925268f;
        this.leftArm.yRot = -0.27925268f;
        return true;
    }

    @Override
    public boolean animateModelBody(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart bodyPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        float ageAmount = ageInTicks * 9.0f * ((float)Math.PI / 180);
        this.body.xRot = limbSwingAmount * 0.6981317f;
        this.root.y += (float)Math.cos(ageAmount) * 0.25f * 1.0f - limbSwingAmount;
        return true;
    }

    @Override
    public boolean additionalModelAnimation(T entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float wingRotationAmount = Mth.cos((float)(ageInTicks * 20.0f * ((float)Math.PI / 180) + limbSwingAmount)) * (float)Math.PI * 0.15f;
        this.rightWing.xRot = 0.43633232f;
        this.rightWing.yRot = -0.61086524f + wingRotationAmount;
        this.leftWing.xRot = 0.43633232f;
        this.leftWing.yRot = 0.61086524f - wingRotationAmount;
        return true;
    }

    public ModelPart getHead() {
        return this.head;
    }

    @Override
    public void translateToHand(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        poseStack.translate(0.0f, 0.0625f, 0.1875f);
        poseStack.mulPose(Axis.XP.rotation(this.rightArm.xRot));
        poseStack.scale(0.7f, 0.7f, 0.7f);
        poseStack.translate(0.0625, 0.0, 0.0);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int lightLevel, int overlay, int color) {
        this.root.render(poseStack, vertexConsumer, lightLevel, overlay, color);
    }
}

