/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.block;

import com.mojang.serialization.MapCodec;
import de.markusbordihn.easynpc.block.entity.BaseEasyNPCSpawnerBlockEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseEasyNPCSpawnerBlock
extends BaseEntityBlock {
    public static final MapCodec<BaseEasyNPCSpawnerBlock> CODEC = BaseEasyNPCSpawnerBlock.simpleCodec(BaseEasyNPCSpawnerBlock::new);
    public static final String NAME = "easy_npc_spawner";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public BaseEasyNPCSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BaseEasyNPCSpawnerBlockEntity(null, blockPos, blockState);
    }

    protected void openMenu(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BaseEasyNPCSpawnerBlockEntity) {
            BaseEasyNPCSpawnerBlockEntity baseEasyNPCSpawnerBlockEntity = (BaseEasyNPCSpawnerBlockEntity)blockEntity;
            player.openMenu((MenuProvider)baseEasyNPCSpawnerBlockEntity);
        }
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BaseEasyNPCSpawnerBlockEntity) {
            BaseEasyNPCSpawnerBlockEntity blockEntityInstance = (BaseEasyNPCSpawnerBlockEntity)blockEntity;
            if (livingEntity != null) {
                blockEntityInstance.setSpawnerUUID(UUID.randomUUID());
                blockEntityInstance.setOwner(livingEntity);
                log.debug("Registered new NPC spawner with UUID {} for owner {} at {}", (Object)blockEntityInstance.getSpawnerUUID(), (Object)blockEntityInstance.getOwner(), (Object)blockPos);
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.openMenu(level, blockPos, player);
        return InteractionResult.CONSUME;
    }

    public RenderShape getRenderShape(BlockState blockstate) {
        return RenderShape.MODEL;
    }
}

