/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.init;

import com.blakebr0.cucumber.block.BaseBlock;
import com.blakebr0.cucumber.block.BaseGlassBlock;
import com.blakebr0.cucumber.block.BaseOreBlock;
import com.blakebr0.cucumber.block.BaseSlabBlock;
import com.blakebr0.cucumber.block.BaseStairsBlock;
import com.blakebr0.cucumber.block.BaseWallBlock;
import com.blakebr0.cucumber.item.BaseBlockItem;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.block.AwakeningAltarBlock;
import com.blakebr0.mysticalagriculture.block.AwakeningPedestalBlock;
import com.blakebr0.mysticalagriculture.block.EnchanterBlock;
import com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock;
import com.blakebr0.mysticalagriculture.block.EssenceVesselBlock;
import com.blakebr0.mysticalagriculture.block.GrowthAcceleratorBlock;
import com.blakebr0.mysticalagriculture.block.HarvesterBlock;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagriculture.block.InfusionAltarBlock;
import com.blakebr0.mysticalagriculture.block.InfusionPedestalBlock;
import com.blakebr0.mysticalagriculture.block.ReprocessorBlock;
import com.blakebr0.mysticalagriculture.block.SoulExtractorBlock;
import com.blakebr0.mysticalagriculture.block.SouliumSpawnerBlock;
import com.blakebr0.mysticalagriculture.block.TinkeringTableBlock;
import com.blakebr0.mysticalagriculture.block.WitherproofBlock;
import com.blakebr0.mysticalagriculture.block.WitherproofGlassBlock;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

public final class ModBlocks {
    public static final Map<DeferredHolder<Block, Block>, Supplier<Block>> ENTRIES = new LinkedHashMap<DeferredHolder<Block, Block>, Supplier<Block>>();
    public static final DeferredHolder<Block, Block> PROSPERITY_BLOCK = ModBlocks.register("prosperity_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> INFERIUM_BLOCK = ModBlocks.register("inferium_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> PRUDENTIUM_BLOCK = ModBlocks.register("prudentium_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> TERTIUM_BLOCK = ModBlocks.register("tertium_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> IMPERIUM_BLOCK = ModBlocks.register("imperium_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 5.0f, true));
    public static final DeferredHolder<Block, Block> SUPREMIUM_BLOCK = ModBlocks.register("supremium_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> AWAKENED_SUPREMIUM_BLOCK = ModBlocks.register("awakened_supremium_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SOULIUM_BLOCK = ModBlocks.register("soulium_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> PROSPERITY_INGOT_BLOCK = ModBlocks.register("prosperity_ingot_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> INFERIUM_INGOT_BLOCK = ModBlocks.register("inferium_ingot_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> PRUDENTIUM_INGOT_BLOCK = ModBlocks.register("prudentium_ingot_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> TERTIUM_INGOT_BLOCK = ModBlocks.register("tertium_ingot_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> IMPERIUM_INGOT_BLOCK = ModBlocks.register("imperium_ingot_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SUPREMIUM_INGOT_BLOCK = ModBlocks.register("supremium_ingot_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> AWAKENED_SUPREMIUM_INGOT_BLOCK = ModBlocks.register("awakened_supremium_ingot_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SOULIUM_INGOT_BLOCK = ModBlocks.register("soulium_ingot_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> PROSPERITY_GEMSTONE_BLOCK = ModBlocks.register("prosperity_gemstone_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> INFERIUM_GEMSTONE_BLOCK = ModBlocks.register("inferium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> PRUDENTIUM_GEMSTONE_BLOCK = ModBlocks.register("prudentium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> TERTIUM_GEMSTONE_BLOCK = ModBlocks.register("tertium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> IMPERIUM_GEMSTONE_BLOCK = ModBlocks.register("imperium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SUPREMIUM_GEMSTONE_BLOCK = ModBlocks.register("supremium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> AWAKENED_SUPREMIUM_GEMSTONE_BLOCK = ModBlocks.register("awakened_supremium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SOULIUM_GEMSTONE_BLOCK = ModBlocks.register("soulium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> INFERIUM_FARMLAND = ModBlocks.register("inferium_farmland", () -> new InfusedFarmlandBlock(CropTier.ONE));
    public static final DeferredHolder<Block, Block> PRUDENTIUM_FARMLAND = ModBlocks.register("prudentium_farmland", () -> new InfusedFarmlandBlock(CropTier.TWO));
    public static final DeferredHolder<Block, Block> TERTIUM_FARMLAND = ModBlocks.register("tertium_farmland", () -> new InfusedFarmlandBlock(CropTier.THREE));
    public static final DeferredHolder<Block, Block> IMPERIUM_FARMLAND = ModBlocks.register("imperium_farmland", () -> new InfusedFarmlandBlock(CropTier.FOUR));
    public static final DeferredHolder<Block, Block> SUPREMIUM_FARMLAND = ModBlocks.register("supremium_farmland", () -> new InfusedFarmlandBlock(CropTier.FIVE));
    public static final DeferredHolder<Block, Block> INFERIUM_GROWTH_ACCELERATOR = ModBlocks.register("inferium_growth_accelerator", () -> new GrowthAcceleratorBlock(9, CropTier.ONE.getTextColor()));
    public static final DeferredHolder<Block, Block> PRUDENTIUM_GROWTH_ACCELERATOR = ModBlocks.register("prudentium_growth_accelerator", () -> new GrowthAcceleratorBlock(18, CropTier.TWO.getTextColor()));
    public static final DeferredHolder<Block, Block> TERTIUM_GROWTH_ACCELERATOR = ModBlocks.register("tertium_growth_accelerator", () -> new GrowthAcceleratorBlock(27, CropTier.THREE.getTextColor()));
    public static final DeferredHolder<Block, Block> IMPERIUM_GROWTH_ACCELERATOR = ModBlocks.register("imperium_growth_accelerator", () -> new GrowthAcceleratorBlock(36, CropTier.FOUR.getTextColor()));
    public static final DeferredHolder<Block, Block> SUPREMIUM_GROWTH_ACCELERATOR = ModBlocks.register("supremium_growth_accelerator", () -> new GrowthAcceleratorBlock(45, CropTier.FIVE.getTextColor()));
    public static final DeferredHolder<Block, Block> AWAKENED_SUPREMIUM_GROWTH_ACCELERATOR = ModBlocks.register("awakened_supremium_growth_accelerator", () -> new GrowthAcceleratorBlock(54, CropTier.FIVE.getTextColor()));
    public static final DeferredHolder<Block, Block> PROSPERITY_ORE = ModBlocks.register("prosperity_ore", () -> new BaseOreBlock(SoundType.STONE, 3.0f, 3.0f, 2, 5));
    public static final DeferredHolder<Block, Block> DEEPSLATE_PROSPERITY_ORE = ModBlocks.register("deepslate_prosperity_ore", () -> new BaseOreBlock(SoundType.DEEPSLATE, 4.5f, 3.0f, 2, 5));
    public static final DeferredHolder<Block, Block> INFERIUM_ORE = ModBlocks.register("inferium_ore", () -> new BaseOreBlock(SoundType.STONE, 3.0f, 3.0f, 2, 5));
    public static final DeferredHolder<Block, Block> DEEPSLATE_INFERIUM_ORE = ModBlocks.register("deepslate_inferium_ore", () -> new BaseOreBlock(SoundType.DEEPSLATE, 4.5f, 3.0f, 2, 5));
    public static final DeferredHolder<Block, Block> SOULIUM_ORE = ModBlocks.register("soulium_ore", () -> new BaseOreBlock(SoundType.STONE, 3.0f, 3.0f, 3, 7));
    public static final DeferredHolder<Block, Block> SOULSTONE = ModBlocks.register("soulstone", () -> new BaseBlock(SoundType.STONE, 1.5f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SOULSTONE_COBBLE = ModBlocks.register("soulstone_cobble", () -> new BaseBlock(SoundType.STONE, 2.0f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SOULSTONE_BRICKS = ModBlocks.register("soulstone_bricks", () -> new BaseBlock(SoundType.STONE, 1.5f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SOULSTONE_CRACKED_BRICKS = ModBlocks.register("soulstone_cracked_bricks", () -> new BaseBlock(SoundType.STONE, 1.5f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SOULSTONE_CHISELED_BRICKS = ModBlocks.register("soulstone_chiseled_bricks", () -> new BaseBlock(SoundType.STONE, 1.5f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SOULSTONE_SMOOTH = ModBlocks.register("soulstone_smooth", () -> new BaseBlock(SoundType.STONE, 1.5f, 6.0f, true));
    public static final DeferredHolder<Block, Block> SOUL_GLASS = ModBlocks.register("soul_glass", () -> new BaseGlassBlock(SoundType.GLASS, 0.3f, 0.3f));
    public static final DeferredHolder<Block, Block> SOULSTONE_SLAB = ModBlocks.register("soulstone_slab", () -> new BaseSlabBlock(SOULSTONE));
    public static final DeferredHolder<Block, Block> SOULSTONE_COBBLE_SLAB = ModBlocks.register("soulstone_cobble_slab", () -> new BaseSlabBlock(SOULSTONE_COBBLE));
    public static final DeferredHolder<Block, Block> SOULSTONE_BRICKS_SLAB = ModBlocks.register("soulstone_bricks_slab", () -> new BaseSlabBlock(SOULSTONE_BRICKS));
    public static final DeferredHolder<Block, Block> SOULSTONE_SMOOTH_SLAB = ModBlocks.register("soulstone_smooth_slab", () -> new BaseSlabBlock(SOULSTONE_SMOOTH));
    public static final DeferredHolder<Block, Block> SOULSTONE_STAIRS = ModBlocks.register("soulstone_stairs", () -> new BaseStairsBlock(((Block)SOULSTONE.get()).defaultBlockState()));
    public static final DeferredHolder<Block, Block> SOULSTONE_COBBLE_STAIRS = ModBlocks.register("soulstone_cobble_stairs", () -> new BaseStairsBlock(((Block)SOULSTONE_COBBLE.get()).defaultBlockState()));
    public static final DeferredHolder<Block, Block> SOULSTONE_BRICKS_STAIRS = ModBlocks.register("soulstone_bricks_stairs", () -> new BaseStairsBlock(((Block)SOULSTONE_BRICKS.get()).defaultBlockState()));
    public static final DeferredHolder<Block, Block> SOULSTONE_COBBLE_WALL = ModBlocks.register("soulstone_cobble_wall", () -> new BaseWallBlock(SOULSTONE_COBBLE));
    public static final DeferredHolder<Block, Block> SOULSTONE_BRICKS_WALL = ModBlocks.register("soulstone_bricks_wall", () -> new BaseWallBlock(SOULSTONE_BRICKS));
    public static final DeferredHolder<Block, Block> WITHERPROOF_BLOCK = ModBlocks.register("witherproof_block", WitherproofBlock::new);
    public static final DeferredHolder<Block, Block> WITHERPROOF_BRICKS = ModBlocks.register("witherproof_bricks", WitherproofBlock::new);
    public static final DeferredHolder<Block, Block> WITHERPROOF_GLASS = ModBlocks.register("witherproof_glass", WitherproofGlassBlock::new);
    public static final DeferredHolder<Block, Block> INFUSION_PEDESTAL = ModBlocks.register("infusion_pedestal", InfusionPedestalBlock::new);
    public static final DeferredHolder<Block, Block> INFUSION_ALTAR = ModBlocks.register("infusion_altar", InfusionAltarBlock::new);
    public static final DeferredHolder<Block, Block> AWAKENING_PEDESTAL = ModBlocks.register("awakening_pedestal", AwakeningPedestalBlock::new);
    public static final DeferredHolder<Block, Block> AWAKENING_ALTAR = ModBlocks.register("awakening_altar", AwakeningAltarBlock::new);
    public static final DeferredHolder<Block, Block> ESSENCE_VESSEL = ModBlocks.register("essence_vessel", EssenceVesselBlock::new);
    public static final DeferredHolder<Block, Block> TINKERING_TABLE = ModBlocks.register("tinkering_table", TinkeringTableBlock::new);
    public static final DeferredHolder<Block, Block> ENCHANTER = ModBlocks.register("enchanter", EnchanterBlock::new);
    public static final DeferredHolder<Block, Block> MACHINE_FRAME = ModBlocks.register("machine_frame", () -> new BaseBlock(SoundType.STONE, 1.5f, 6.0f, true));
    public static final DeferredHolder<Block, Block> FURNACE = ModBlocks.register("furnace", EssenceFurnaceBlock::new);
    public static final DeferredHolder<Block, Block> REPROCESSOR = ModBlocks.register("seed_reprocessor", ReprocessorBlock::new);
    public static final DeferredHolder<Block, Block> SOUL_EXTRACTOR = ModBlocks.register("soul_extractor", SoulExtractorBlock::new);
    public static final DeferredHolder<Block, Block> HARVESTER = ModBlocks.register("harvester", HarvesterBlock::new);
    public static final DeferredHolder<Block, Block> SOULIUM_SPAWNER = ModBlocks.register("soulium_spawner", SouliumSpawnerBlock::new);
    public static final DeferredHolder<Block, Block> INFERIUM_CROP = ModBlocks.registerNoItem("inferium_crop", () -> new InferiumCropBlock(ModCrops.INFERIUM));

    @SubscribeEvent
    public void onRegisterBlocks(RegisterEvent event) {
        event.register(Registries.BLOCK, (T registry) -> {
            ENTRIES.forEach((reg, block) -> registry.register(reg.getId(), (Object)((Block)block.get())));
            CropRegistry.getInstance().setAllowRegistration(true);
            CropRegistry.getInstance().onRegisterBlocks((RegisterEvent.RegisterHelper<Block>)registry);
            CropRegistry.getInstance().setAllowRegistration(false);
        });
    }

    private static DeferredHolder<Block, Block> register(String name, Supplier<Block> block) {
        return ModBlocks.register(name, block, b -> () -> new BaseBlockItem((Block)b.get()));
    }

    private static DeferredHolder<Block, Block> register(String name, Supplier<Block> block, Function<DeferredHolder<Block, Block>, Supplier<? extends BlockItem>> item) {
        DeferredHolder<Block, Block> holder = ModBlocks.registerNoItem(name, block);
        ModItems.BLOCK_ENTRIES.add(() -> (BlockItem)((Supplier)item.apply(holder)).get());
        return holder;
    }

    public static DeferredHolder<Block, Block> registerNoItem(String name, Supplier<Block> block) {
        ResourceLocation id = MysticalAgriculture.resource(name);
        DeferredHolder holder = DeferredHolder.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
        ENTRIES.put((DeferredHolder<Block, Block>)holder, block);
        return holder;
    }
}

