/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.recipe;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalagriculture.crafting.condition.CropEnabledCondition;
import com.blakebr0.mysticalagriculture.crafting.condition.CropHasMaterialCondition;
import com.blakebr0.mysticalagriculture.crafting.condition.SeedCraftingRecipesEnabledCondition;
import com.blakebr0.mysticalagriculture.crafting.ingredient.CropComponentIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public class CraftingRecipeBuilder {
    private final ItemStack result;
    private String group = "";
    private ShapedRecipePattern pattern;
    private CraftingBookCategory category;
    private final List<ICondition> conditions;

    public CraftingRecipeBuilder(ItemStack result) {
        this.result = result;
        this.conditions = new ArrayList<ICondition>();
    }

    public void addCondition(ICondition condition) {
        this.conditions.add(condition);
    }

    public void build(RecipeOutput consumer, ResourceLocation id) {
        consumer.accept(id, (Recipe)new ShapedRecipe(this.group, this.category, this.pattern, this.result), null, this.conditions.toArray(new ICondition[0]));
    }

    public static CraftingRecipeBuilder newSeedRecipe(Crop crop) {
        CraftingRecipeBuilder builder = new CraftingRecipeBuilder(new ItemStack((ItemLike)crop.getSeedsItem()));
        Ingredient essence = CropComponentIngredient.of(crop.getId(), CropComponentIngredient.ComponentType.ESSENCE);
        Ingredient seed = CropComponentIngredient.of(crop.getId(), CropComponentIngredient.ComponentType.SEED);
        Ingredient material = CropComponentIngredient.of(crop.getId(), CropComponentIngredient.ComponentType.MATERIAL);
        builder.group = "mysticalagriculture:seeds";
        builder.category = CraftingBookCategory.MISC;
        builder.pattern = ShapedRecipePattern.of(Map.of(Character.valueOf('E'), essence, Character.valueOf('S'), seed, Character.valueOf('M'), material), (String[])new String[]{"MEM", "ESE", "MEM"});
        builder.addCondition(new SeedCraftingRecipesEnabledCondition());
        builder.addCondition(new CropEnabledCondition(crop.getId()));
        builder.addCondition(new CropHasMaterialCondition(crop.getId()));
        LazyIngredient ingredient = crop.getLazyIngredient();
        if (ingredient.isTag()) {
            builder.addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(ingredient.getId())));
        }
        return builder;
    }
}

