/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.McJtyLib;
import mcjty.lib.blockcommands.CommandInfo;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSendResultToClient(BlockPos pos, String command, List list) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mcjtylib", (String)"sendresulttoclient");
    public static final CustomPacketPayload.Type<PacketSendResultToClient> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketSendResultToClient> CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeBlockPos(packet.pos);
        buf.writeUtf(packet.command);
        CommandInfo info = McJtyLib.getCommandInfo(packet.command);
        if (info == null) {
            throw new IllegalStateException("Command '" + packet.command + "' is not registered!");
        }
        BiConsumer<FriendlyByteBuf, FriendlyByteBuf> serializer = info.serializer();
        if (serializer == null) {
            throw new IllegalStateException("Command '" + packet.command + "' is not registered!");
        }
        if (packet.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(packet.list.size());
            for (Object item : packet.list) {
                serializer.accept((FriendlyByteBuf)buf, (FriendlyByteBuf)item);
            }
        }
    }, buf -> {
        ArrayList list;
        BlockPos pos = buf.readBlockPos();
        String command = buf.readUtf(Short.MAX_VALUE);
        CommandInfo info = McJtyLib.getCommandInfo(command);
        if (info == null) {
            throw new IllegalStateException("Command '" + command + "' is not registered!");
        }
        Function<FriendlyByteBuf, FriendlyByteBuf> deserializer = info.deserializer();
        int size = buf.readInt();
        if (size != -1) {
            list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                list.add(deserializer.apply((FriendlyByteBuf)buf));
            }
        } else {
            list = null;
        }
        return new PacketSendResultToClient(pos, command, list);
    });

    public static PacketSendResultToClient create(BlockPos pos, String command, List list) {
        return new PacketSendResultToClient(pos, command, new ArrayList(list));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity te = SafeClientTools.getClientWorld().getBlockEntity(this.pos);
            if (te instanceof GenericTileEntity) {
                GenericTileEntity generic = (GenericTileEntity)te;
                generic.handleListFromServer(this.command, SafeClientTools.getClientPlayer(), TypedMap.EMPTY, this.list);
            } else {
                Logging.logError("Can't handle command '" + this.command + "'!");
            }
        });
    }
}

