/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import vazkii.morphtool.ConfigHandler;
import vazkii.morphtool.MorphingHandler;

public record MessageMorphTool(ItemStack stack, int slot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageMorphTool> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"morphtool", (String)"tool_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageMorphTool> STREAM_CODEC = CustomPacketPayload.codec(MessageMorphTool::serialize, MessageMorphTool::new);

    public MessageMorphTool(RegistryFriendlyByteBuf buf) {
        this((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf), buf.readInt());
    }

    public void serialize(RegistryFriendlyByteBuf buf) {
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)this.stack);
        buf.writeInt(this.slot);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(MessageMorphTool msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player;
            ItemStack mainHandItem;
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer && MorphingHandler.isMorphTool(mainHandItem = (player = (ServerPlayer)patt0$temp).getItemInHand((Boolean)ConfigHandler.invertHandShift.get() != false ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND)) && msg.stack() != mainHandItem && !ItemStack.isSameItem((ItemStack)msg.stack(), (ItemStack)mainHandItem)) {
                Inventory inventory = player.getInventory();
                inventory.setItem((Boolean)ConfigHandler.invertHandShift.get() != false ? inventory.getContainerSize() - 1 : msg.slot(), msg.stack());
            }
        });
    }
}

