/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.video.element;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.elements.video.IVideoElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VideoElementDurationPlaceholder
extends Placeholder {
    public VideoElementDurationPlaceholder() {
        super("video_element_duration");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        AbstractElement element;
        ScreenCustomizationLayer layer;
        String elementId = dps.values.get("element_identifier");
        if (elementId != null && (layer = ScreenCustomizationLayerHandler.getActiveLayer()) != null && (element = layer.getElementByInstanceIdentifier(elementId)) instanceof IVideoElement) {
            IVideoElement video = (IVideoElement)((Object)element);
            float durationSeconds = video.getDuration();
            int minutes = (int)(durationSeconds / 60.0f);
            int seconds = (int)(durationSeconds % 60.0f);
            return String.format("%02d:%02d", minutes, seconds);
        }
        return "00:00";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("element_identifier");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.video_element_duration", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.video_element_duration.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.placeholders.categories.video", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("element_identifier", "put_identifier_of_video_element_here");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

