/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.scoreboard;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardDisplaySlotPlaceholder
extends Placeholder {
    public ScoreboardDisplaySlotPlaceholder() {
        super("scoreboard_display_slot");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        ClientLevel level = Minecraft.getInstance().level;
        String slotName = dps.values.get("slot");
        if (level != null && slotName != null) {
            Objective objective;
            Scoreboard scoreboard = level.getScoreboard();
            DisplaySlot slot = (DisplaySlot)DisplaySlot.CODEC.byName(slotName);
            if (slot != null && (objective = scoreboard.getDisplayObjective(slot)) != null) {
                return objective.getName();
            }
        }
        return "";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("slot");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.scoreboard.display_slot", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.scoreboard.display_slot.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.placeholders.categories.scoreboard", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("slot", "sidebar");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

