/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceTextPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public ReplaceTextPlaceholder() {
        super("replace_text");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String text = dps.values.get("text");
        String search = dps.values.get("search");
        String replacement = dps.values.get("replacement");
        boolean useRegex = SerializationUtils.deserializeBoolean(false, dps.values.get("use_regex"));
        boolean replaceAll = SerializationUtils.deserializeBoolean(true, dps.values.get("replace_all"));
        if (text == null || search == null) {
            return "";
        }
        if (replacement == null) {
            replacement = "";
        }
        try {
            if (useRegex) {
                Pattern pattern = Pattern.compile(search);
                if (replaceAll) {
                    return pattern.matcher(text).replaceAll(replacement);
                }
                return pattern.matcher(text).replaceFirst(replacement);
            }
            String quotedSearch = Pattern.quote(search);
            if (replaceAll) {
                return text.replaceAll(quotedSearch, replacement);
            }
            return text.replaceFirst(quotedSearch, replacement);
        }
        catch (PatternSyntaxException e) {
            LOGGER.error("[FANCYMENU] Invalid regex pattern in 'Replace Text' placeholder: " + search, (Throwable)e);
            return text;
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error in 'Replace Text' placeholder: " + dps.placeholderString, (Throwable)e);
            return text;
        }
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("text", "search", "replacement", "use_regex", "replace_all");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.replace_text", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.replace_text.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.requirements.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("text", "Hello World! This is a test.");
        values.put("search", "World");
        values.put("replacement", "FancyMenu");
        values.put("use_regex", "false");
        values.put("replace_all", "true");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

