/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.internal;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.action.ValuePlaceholderHolder;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirementRegistry;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingRequirementInstance
implements ValuePlaceholderHolder {
    public LoadingRequirementContainer parent;
    public LoadingRequirement requirement;
    @Nullable
    public String value;
    protected final Map<String, Supplier<String>> valuePlaceholders = new HashMap<String, Supplier<String>>();
    @Nullable
    public LoadingRequirementGroup group;
    public RequirementMode mode;
    public String instanceIdentifier = ScreenCustomization.generateUniqueIdentifier();

    public LoadingRequirementInstance(LoadingRequirement requirement, @Nullable String value, RequirementMode mode, LoadingRequirementContainer parent) {
        this.parent = parent;
        this.requirement = requirement;
        this.value = value;
        this.mode = mode;
    }

    public boolean requirementMet() {
        if (!this.requirement.checkAsync()) {
            return false;
        }
        String v = this.value;
        if (v != null) {
            for (Map.Entry<String, Supplier<String>> m : this.valuePlaceholders.entrySet()) {
                String replaceWith = m.getValue().get();
                if (replaceWith == null) {
                    replaceWith = "";
                }
                v = v.replace("$$" + m.getKey(), replaceWith);
            }
            v = PlaceholderParser.replacePlaceholders(v);
        }
        this.requirement.setCurrentInstance(this);
        boolean met = this.requirement.isRequirementMet(v);
        if (this.mode == RequirementMode.IF_NOT) {
            return !met;
        }
        return met;
    }

    @Override
    public void addValuePlaceholder(@NotNull String placeholder, @NotNull Supplier<String> replaceWithSupplier) {
        if (!CharacterFilter.buildResourceNameFilter().isAllowedText(placeholder)) {
            throw new RuntimeException("Illegal characters used in placeholder name! Use only [a-z], [0-9], [_], [-]!");
        }
        this.valuePlaceholders.put(placeholder, replaceWithSupplier);
    }

    @Override
    @NotNull
    public Map<String, Supplier<String>> getValuePlaceholders() {
        return this.valuePlaceholders;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof LoadingRequirementInstance) {
            LoadingRequirementInstance other = (LoadingRequirementInstance)o;
            if (!Objects.equals(this.instanceIdentifier, other.instanceIdentifier)) {
                return false;
            }
            if (this.requirement != other.requirement) {
                return false;
            }
            if (!Objects.equals(this.value, other.value)) {
                return false;
            }
            return this.mode == other.mode;
        }
        return false;
    }

    public LoadingRequirementInstance copy(boolean unique) {
        LoadingRequirementInstance i = new LoadingRequirementInstance(this.requirement, this.value, this.mode, null);
        if (!unique) {
            i.instanceIdentifier = this.instanceIdentifier;
        }
        i.valuePlaceholders.putAll(this.valuePlaceholders);
        return i;
    }

    @NotNull
    public static List<String> serializeRequirementInstance(@NotNull LoadingRequirementInstance instance) {
        ArrayList<String> l = new ArrayList<String>();
        String key = "[loading_requirement:" + instance.requirement.getIdentifier() + "][requirement_mode:" + instance.mode.name + "]";
        if (instance.group != null) {
            key = key + "[group:" + instance.group.identifier + "]";
        }
        key = key + "[req_id:" + instance.instanceIdentifier + "]";
        l.add(key);
        if (instance.requirement.hasValue() && instance.value != null) {
            l.add(instance.value);
        } else {
            l.add("");
        }
        return l;
    }

    @Nullable
    public static LoadingRequirementInstance deserializeRequirementInstance(@NotNull String key, @Nullable String value, @NotNull LoadingRequirementContainer parent) {
        String modeName;
        RequirementMode mode;
        String reqId;
        LoadingRequirement req;
        if (key.startsWith("[loading_requirement:") && (req = LoadingRequirementRegistry.getRequirement(reqId = key.split(":", 2)[1].split("\\]", 2)[0])) != null && key.contains("[requirement_mode:") && (mode = RequirementMode.getByName(modeName = key.split("\\[requirement_mode:", 2)[1].split("\\]", 2)[0])) != null) {
            LoadingRequirementGroup group = null;
            if (key.contains("[group:")) {
                String groupId = key.split("\\[group:", 2)[1].split("\\]", 2)[0];
                if (!parent.groupExists(groupId)) {
                    parent.createAndAddGroup(groupId, LoadingRequirementGroup.GroupMode.AND);
                }
                group = parent.getGroup(groupId);
            }
            if (key.contains("[req_id:")) {
                String id = key.split("\\[req_id:", 2)[1].split("\\]", 2)[0];
                LoadingRequirementInstance instance = new LoadingRequirementInstance(req, value, mode, parent);
                if (!req.hasValue()) {
                    instance.value = null;
                }
                instance.instanceIdentifier = id;
                instance.group = group;
                return instance;
            }
        }
        return null;
    }

    public static enum RequirementMode {
        IF("if"),
        IF_NOT("if_not");

        public final String name;

        private RequirementMode(String name) {
            this.name = name;
        }

        @Nullable
        public static RequirementMode getByName(String name) {
            for (RequirementMode m : RequirementMode.values()) {
                if (!m.name.equals(name)) continue;
                return m;
            }
            return null;
        }
    }
}

