/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.internal;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.action.ValuePlaceholderHolder;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.Pair;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingRequirementContainer
implements ValuePlaceholderHolder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Pair<Long, Boolean>> COOLDOWN_CACHE = new HashMap<String, Pair<Long, Boolean>>();
    protected final List<LoadingRequirementGroup> groups = new ArrayList<LoadingRequirementGroup>();
    protected final List<LoadingRequirementInstance> instances = new ArrayList<LoadingRequirementInstance>();
    protected final Map<String, Supplier<String>> valuePlaceholders = new HashMap<String, Supplier<String>>();
    @NotNull
    public String identifier = ScreenCustomization.generateUniqueIdentifier();
    protected boolean forceRequirementsMet = false;
    protected boolean forceRequirementsNotMet = false;
    protected final String cachingIdentifier = ScreenCustomization.generateUniqueIdentifier();

    public static boolean isCachingRequirements() {
        return FancyMenu.getOptions().requirementCachingDurationMs.getValue() > 0L;
    }

    public static long getRequirementCachingDurationMs() {
        return FancyMenu.getOptions().requirementCachingDurationMs.getValue();
    }

    public boolean requirementsMet() {
        long now = System.currentTimeMillis();
        if (LoadingRequirementContainer.isCachingRequirements() && COOLDOWN_CACHE.containsKey(this.cachingIdentifier) && COOLDOWN_CACHE.get(this.cachingIdentifier).getKey() + LoadingRequirementContainer.getRequirementCachingDurationMs() > now) {
            return COOLDOWN_CACHE.get(this.cachingIdentifier).getValue();
        }
        boolean b = this._requirementsMet();
        if (LoadingRequirementContainer.isCachingRequirements()) {
            COOLDOWN_CACHE.put(this.cachingIdentifier, Pair.of(now, b));
        }
        return b;
    }

    private boolean _requirementsMet() {
        if (this.forceRequirementsMet) {
            return true;
        }
        if (this.forceRequirementsNotMet) {
            return false;
        }
        try {
            for (LoadingRequirementGroup g : this.groups) {
                if (g.requirementsMet()) continue;
                return false;
            }
            for (LoadingRequirementInstance i : this.instances) {
                if (i.requirementMet()) continue;
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error while checking LoadingRequirements of LoadingRequirementContainer!", (Throwable)e);
            return false;
        }
        return true;
    }

    @Nullable
    public LoadingRequirementGroup createAndAddGroup(@NotNull String identifier, @NotNull LoadingRequirementGroup.GroupMode mode) {
        if (!this.groupExists(identifier)) {
            LoadingRequirementGroup g = new LoadingRequirementGroup(identifier, mode, this);
            this.groups.add(g);
            this.valuePlaceholders.forEach(g::addValuePlaceholder);
            return g;
        }
        return null;
    }

    public boolean addGroup(@NotNull LoadingRequirementGroup group) {
        if (!this.groupExists(group.identifier)) {
            this.groups.add(group);
            this.valuePlaceholders.forEach(group::addValuePlaceholder);
            return true;
        }
        return false;
    }

    public List<LoadingRequirementGroup> getGroups() {
        return new ArrayList<LoadingRequirementGroup>(this.groups);
    }

    @Nullable
    public LoadingRequirementGroup getGroup(@NotNull String identifier) {
        for (LoadingRequirementGroup g : this.groups) {
            if (!g.identifier.equals(identifier)) continue;
            return g;
        }
        return null;
    }

    public boolean groupExists(@NotNull String identifier) {
        return this.getGroup(identifier) != null;
    }

    public boolean removeGroup(@NotNull LoadingRequirementGroup group) {
        return this.groups.remove(Objects.requireNonNull(group));
    }

    public boolean removeGroupByIdentifier(@NotNull String identifier) {
        LoadingRequirementGroup g = this.getGroup(identifier);
        if (g != null) {
            return this.groups.remove(g);
        }
        return false;
    }

    public boolean addInstance(@NotNull LoadingRequirementInstance instance) {
        if (!this.instances.contains(instance)) {
            this.instances.add(instance);
            this.valuePlaceholders.forEach(instance::addValuePlaceholder);
            return true;
        }
        return false;
    }

    public boolean removeInstance(@NotNull LoadingRequirementInstance instance) {
        return this.instances.remove(instance);
    }

    public List<LoadingRequirementInstance> getInstances() {
        return new ArrayList<LoadingRequirementInstance>(this.instances);
    }

    public LoadingRequirementContainer forceRequirementsMet(boolean forceMet) {
        this.forceRequirementsMet = forceMet;
        this.forceRequirementsNotMet = false;
        return this;
    }

    public LoadingRequirementContainer forceRequirementsNotMet(boolean forceNotMet) {
        this.forceRequirementsNotMet = forceNotMet;
        this.forceRequirementsMet = false;
        return this;
    }

    public boolean isEmpty() {
        return this.groups.isEmpty() && this.instances.isEmpty();
    }

    @Override
    public void addValuePlaceholder(@NotNull String placeholder, @NotNull Supplier<String> replaceWithSupplier) {
        if (!CharacterFilter.buildResourceNameFilter().isAllowedText(placeholder)) {
            throw new RuntimeException("Illegal characters used in placeholder name! Use only [a-z], [0-9], [_], [-]!");
        }
        this.valuePlaceholders.put(placeholder, replaceWithSupplier);
        for (LoadingRequirementInstance i : this.instances) {
            i.addValuePlaceholder(placeholder, replaceWithSupplier);
        }
        for (LoadingRequirementGroup g : this.groups) {
            g.addValuePlaceholder(placeholder, replaceWithSupplier);
        }
    }

    @Override
    @NotNull
    public Map<String, Supplier<String>> getValuePlaceholders() {
        return this.valuePlaceholders;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof LoadingRequirementContainer) {
            LoadingRequirementContainer other = (LoadingRequirementContainer)o;
            if (!Objects.equals(this.identifier, other.identifier)) {
                return false;
            }
            if (!ListUtils.contentEqualIgnoreOrder(this.groups, other.groups)) {
                return false;
            }
            return ListUtils.contentEqualIgnoreOrder(this.instances, other.instances);
        }
        return false;
    }

    public LoadingRequirementContainer copy(boolean unique) {
        LoadingRequirementContainer c = new LoadingRequirementContainer();
        if (!unique) {
            c.identifier = this.identifier;
        }
        this.groups.forEach(group -> {
            LoadingRequirementGroup g = group.copy(unique);
            g.parent = c;
            for (LoadingRequirementInstance i : g.instances) {
                i.parent = c;
            }
            c.groups.add(g);
        });
        this.instances.forEach(instance -> {
            LoadingRequirementInstance i = instance.copy(unique);
            i.parent = c;
            c.instances.add(i);
        });
        c.valuePlaceholders.putAll(this.valuePlaceholders);
        return c;
    }

    public void serializeToExistingPropertyContainer(@NotNull PropertyContainer target) {
        PropertyContainer sec = this.serialize();
        for (Map.Entry<String, String> m : sec.getProperties().entrySet()) {
            target.putProperty(m.getKey(), m.getValue());
        }
    }

    @NotNull
    public PropertyContainer serialize() {
        PropertyContainer container = new PropertyContainer("loading_requirement_container");
        String containerMetaKey = "[loading_requirement_container_meta:" + this.identifier + "]";
        Object containerMetaValue = "[groups:";
        for (LoadingRequirementGroup g : this.groups) {
            containerMetaValue = (String)containerMetaValue + g.identifier + ";";
        }
        containerMetaValue = (String)containerMetaValue + "][instances:";
        for (LoadingRequirementInstance i : this.instances) {
            containerMetaValue = (String)containerMetaValue + i.instanceIdentifier + ";";
        }
        containerMetaValue = (String)containerMetaValue + "]";
        container.putProperty(containerMetaKey, (String)containerMetaValue);
        for (LoadingRequirementGroup g : this.groups) {
            PropertyContainer sg = LoadingRequirementGroup.serializeRequirementGroup(g);
            for (Map.Entry<String, String> m : sg.getProperties().entrySet()) {
                container.putProperty(m.getKey(), m.getValue());
            }
        }
        for (LoadingRequirementInstance i : this.instances) {
            List<String> l = LoadingRequirementInstance.serializeRequirementInstance(i);
            container.putProperty(l.get(0), l.get(1));
        }
        return container;
    }

    @Nullable
    public static LoadingRequirementContainer deserializeWithIdentifier(@NotNull String identifier, @NotNull PropertyContainer serialized) {
        for (LoadingRequirementContainer c : LoadingRequirementContainer.deserializeAll(serialized)) {
            if (!c.identifier.equals(Objects.requireNonNull(identifier))) continue;
            return c;
        }
        return null;
    }

    @NotNull
    public static List<LoadingRequirementContainer> deserializeAll(@NotNull PropertyContainer serialized) {
        ArrayList<LoadingRequirementContainer> containers = new ArrayList<LoadingRequirementContainer>();
        ArrayList<List<String>> containerMetas = new ArrayList<List<String>>();
        for (Map.Entry<String, String> m : Objects.requireNonNull(serialized).getProperties().entrySet()) {
            if (!m.getKey().startsWith("[loading_requirement_container_meta:")) continue;
            containerMetas.add(ListUtils.of(m.getKey(), m.getValue()));
        }
        LoadingRequirementContainer combined = LoadingRequirementContainer.deserializeToSingleContainer(serialized);
        if (containerMetas.isEmpty()) {
            containers.add(combined);
        } else {
            for (List list : containerMetas) {
                String instancesRaw;
                String groupsRaw;
                String identifier;
                String key = (String)list.get(0);
                String value = (String)list.get(1);
                if (!key.contains("[loading_requirement_container_meta:") || !(identifier = key.split("\\[loading_requirement_container_meta:", 2)[1]).contains("]")) continue;
                identifier = identifier.split("]", 2)[0];
                List<Object> groupIdentifiers = new ArrayList();
                List<Object> instanceIdentifiers = new ArrayList();
                if (value.contains("[groups:") && (groupsRaw = value.split("\\[groups:", 2)[1]).contains("]") && (groupsRaw = groupsRaw.split("]", 2)[0]).contains(";")) {
                    groupIdentifiers = Arrays.asList(groupsRaw.split(";"));
                }
                if (value.contains("[instances:") && (instancesRaw = value.split("\\[instances:", 2)[1]).contains("]") && (instancesRaw = instancesRaw.split("]", 2)[0]).contains(";")) {
                    instanceIdentifiers = Arrays.asList(instancesRaw.split(";"));
                }
                if (identifier.replace(" ", "").isEmpty()) continue;
                LoadingRequirementContainer container = new LoadingRequirementContainer();
                container.identifier = identifier;
                block2: for (String groupId : groupIdentifiers) {
                    for (LoadingRequirementGroup g : combined.groups) {
                        if (!g.identifier.equals(groupId)) continue;
                        container.groups.add(g);
                        continue block2;
                    }
                }
                block4: for (String instanceId : instanceIdentifiers) {
                    for (LoadingRequirementInstance i : combined.instances) {
                        if (!i.instanceIdentifier.equals(instanceId)) continue;
                        container.instances.add(i);
                        continue block4;
                    }
                }
                containers.add(container);
            }
        }
        return containers;
    }

    @NotNull
    public static LoadingRequirementContainer deserializeToSingleContainer(@NotNull PropertyContainer serialized) {
        LoadingRequirementContainer c = new LoadingRequirementContainer();
        for (Map.Entry<String, String> m : Objects.requireNonNull(serialized).getProperties().entrySet()) {
            LoadingRequirementGroup g;
            if (!m.getKey().startsWith("[loading_requirement_group:") || (g = LoadingRequirementGroup.deserializeRequirementGroup(m.getKey(), m.getValue(), c)) == null) continue;
            c.addGroup(g);
        }
        for (Map.Entry<String, String> m : serialized.getProperties().entrySet()) {
            LoadingRequirementInstance i;
            if (!m.getKey().startsWith("[loading_requirement:") || (i = LoadingRequirementInstance.deserializeRequirementInstance(m.getKey(), m.getValue(), c)) == null) continue;
            if (i.group != null) {
                i.group.addInstance(i);
                continue;
            }
            c.addInstance(i);
        }
        return c;
    }

    public static LoadingRequirementContainer stackContainers(LoadingRequirementContainer ... containers) {
        LoadingRequirementContainer stack = new LoadingRequirementContainer();
        for (LoadingRequirementContainer c : containers) {
            LoadingRequirementContainer copy = c.copy(true);
            stack.instances.addAll(copy.instances);
            stack.groups.addAll(copy.groups);
        }
        for (LoadingRequirementInstance i : stack.instances) {
            i.parent = stack;
        }
        for (LoadingRequirementGroup g : stack.groups) {
            g.parent = stack;
            for (LoadingRequirementInstance i : g.instances) {
                i.parent = stack;
            }
        }
        return stack;
    }
}

