/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class OnVariableUpdatedListener
extends AbstractListener {
    private static final Logger LOGGER = LogManager.getLogger();
    protected String varName;
    protected String oldValue;
    protected String newValue;

    public OnVariableUpdatedListener() {
        super("fm_variable_updated");
    }

    public void onVariableUpdated(@NotNull String varName, @NotNull String oldValue, @NotNull String newValue) {
        this.varName = varName;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("var_name", () -> {
            if (this.varName == null) {
                return "ERROR";
            }
            return this.varName;
        }));
        list.add(new AbstractListener.CustomVariable("old_value", () -> {
            if (this.oldValue == null) {
                return "0";
            }
            return this.oldValue;
        }));
        list.add(new AbstractListener.CustomVariable("new_value", () -> {
            if (this.newValue == null) {
                return "0";
            }
            return this.newValue;
        }));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_variable_updated");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_variable_updated.desc", new String[0]));
    }
}

