/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class AutoScalingScreen
extends CellScreen {
    protected LayoutEditorScreen editor;
    protected Consumer<Boolean> callback;
    protected int autoScalingWidth;
    protected int autoScalingHeight;

    protected AutoScalingScreen(@NotNull LayoutEditorScreen editor, @NotNull Consumer<Boolean> callback) {
        super((Component)Component.translatable((String)"fancymenu.editor.auto_scaling.configure"));
        this.editor = editor;
        this.callback = callback;
        this.autoScalingWidth = Minecraft.getInstance().getWindow().getScreenWidth();
        this.autoScalingHeight = Minecraft.getInstance().getWindow().getScreenHeight();
    }

    @Override
    protected void initCells() {
        this.addSpacerCell(20);
        this.addLabelCell((Component)Component.translatable((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line1"));
        this.addLabelCell((Component)Component.translatable((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line2"));
        this.addLabelCell((Component)Component.translatable((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line3"));
        this.addDescriptionEndSeparatorCell();
        this.addLabelCell((Component)Component.translatable((String)"fancymenu.editor.auto_scaling.configure.width"));
        this.addTextInputCell(CharacterFilter.buildIntegerFiler(), false, false).setText("" + this.autoScalingWidth).setEditListener(s -> {
            this.autoScalingWidth = MathUtils.isInteger((String)s) ? Integer.parseInt(s) : -1000;
        });
        this.addCellGroupEndSpacerCell();
        this.addLabelCell((Component)Component.translatable((String)"fancymenu.editor.auto_scaling.configure.height"));
        this.addTextInputCell(CharacterFilter.buildIntegerFiler(), false, false).setText("" + this.autoScalingHeight).setEditListener(s -> {
            this.autoScalingHeight = MathUtils.isInteger((String)s) ? Integer.parseInt(s) : -1000;
        });
        this.addCellGroupEndSpacerCell();
        this.addLabelCell((Component)Component.translatable((String)"fancymenu.editor.auto_scaling.configure.current_screen_width", (Object[])new Object[]{Component.literal((String)("" + Minecraft.getInstance().getWindow().getScreenWidth())).setStyle(Style.EMPTY.withBold(Boolean.valueOf(false)))}).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
        this.addLabelCell((Component)Component.translatable((String)"fancymenu.editor.auto_scaling.configure.current_screen_height", (Object[])new Object[]{Component.literal((String)("" + Minecraft.getInstance().getWindow().getScreenHeight())).setStyle(Style.EMPTY.withBold(Boolean.valueOf(false)))}).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
        this.addSpacerCell(20);
    }

    @Override
    public boolean allowDone() {
        return this.autoScalingWidth != -1000 && this.autoScalingHeight != -1000;
    }

    @Override
    protected void onCancel() {
        this.callback.accept(false);
    }

    @Override
    protected void onDone() {
        this.editor.history.saveSnapshot();
        this.editor.layout.autoScalingWidth = this.autoScalingWidth;
        this.editor.layout.autoScalingHeight = this.autoScalingHeight;
        this.callback.accept(true);
    }
}

