/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.framework;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ActionResult;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.Environment;
import com.mrcrayfish.configured.api.ExecutionContext;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.ClientSessionData;
import com.mrcrayfish.configured.impl.framework.FrameworkConfigHelper;
import com.mrcrayfish.configured.impl.framework.FrameworkFolderEntry;
import com.mrcrayfish.configured.impl.framework.FrameworkValue;
import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.util.ConfigHelper;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import com.mrcrayfish.framework.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class FrameworkModConfig
implements IModConfig {
    private static final Map<com.mrcrayfish.framework.api.config.ConfigType, ConfigType> TYPE_MAPPER = (Map)Util.make(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)com.mrcrayfish.framework.api.config.ConfigType.CLIENT, (Object)ConfigType.CLIENT);
        builder.put((Object)com.mrcrayfish.framework.api.config.ConfigType.UNIVERSAL, (Object)ConfigType.UNIVERSAL);
        builder.put((Object)com.mrcrayfish.framework.api.config.ConfigType.SERVER, (Object)ConfigType.SERVER);
        builder.put((Object)com.mrcrayfish.framework.api.config.ConfigType.SERVER_SYNC, (Object)ConfigType.SERVER_SYNC);
        builder.put((Object)com.mrcrayfish.framework.api.config.ConfigType.DEDICATED_SERVER, (Object)ConfigType.DEDICATED_SERVER);
        builder.put((Object)com.mrcrayfish.framework.api.config.ConfigType.WORLD, (Object)ConfigType.WORLD);
        builder.put((Object)com.mrcrayfish.framework.api.config.ConfigType.WORLD_SYNC, (Object)ConfigType.WORLD_SYNC);
        builder.put((Object)com.mrcrayfish.framework.api.config.ConfigType.MEMORY, (Object)ConfigType.MEMORY);
        return builder.build();
    });
    private final FrameworkConfigManager.FrameworkConfigImpl config;
    private final Supplier<PropertyMap> map;

    public FrameworkModConfig(FrameworkConfigManager.FrameworkConfigImpl config) {
        this.config = config;
        this.map = Suppliers.memoize(() -> new PropertyMap(config));
    }

    @Override
    public ActionResult update(IConfigEntry entry) {
        UnmodifiableConfig unmodifiableConfig;
        Preconditions.checkState((this.config.getConfig() != null ? 1 : 0) != 0, (Object)"Tried to update a config that is not loaded");
        if (this.config.isReadOnly() || !((unmodifiableConfig = this.config.getConfig()) instanceof Config)) {
            return ActionResult.fail((Component)Component.translatable((String)"configured.gui.update_error.read_only"));
        }
        Config configData = (Config)unmodifiableConfig;
        Set<IConfigValue<?>> changedValues = ConfigHelper.getChangedValues(entry);
        if (changedValues.isEmpty()) {
            return ActionResult.success();
        }
        CommentedConfig newConfigData = CommentedConfig.inMemory();
        changedValues.forEach(value -> {
            if (value instanceof FrameworkValue) {
                FrameworkValue frameworkValue = (FrameworkValue)value;
                newConfigData.set(frameworkValue.getPath(), frameworkValue.get());
            }
        });
        configData.putAll((UnmodifiableConfig)newConfigData);
        this.config.correct((UnmodifiableConfig)configData);
        this.config.getAllProperties().forEach(AbstractProperty::invalidateCache);
        if (this.getType().isServer()) {
            if (!ConfigHelper.isPlayingGame()) {
                this.config.unload(false);
                return ActionResult.success();
            }
            this.syncToServer();
            if (!ConfigHelper.isIntegratedServer() && !this.getType().isSync()) {
                this.config.unload(false);
                return ActionResult.success();
            }
        }
        Constants.LOG.info("Sending config reloading event for {}", (Object)this.getFileName());
        ((FrameworkConfigEvents.Reload)FrameworkConfigEvents.RELOAD.post()).handle(this.config.getSource());
        return ActionResult.success();
    }

    @Override
    public IConfigEntry createRootEntry() {
        return new FrameworkFolderEntry((PropertyMap)this.map.get());
    }

    @Override
    public ConfigType getType() {
        return TYPE_MAPPER.get(this.config.getType());
    }

    @Override
    public String getFileName() {
        return this.config.getFileName();
    }

    @Override
    public String getModId() {
        return this.config.getName().getNamespace();
    }

    @Override
    public ActionResult loadWorldConfig(Path path) {
        if (!this.config.isLoaded()) {
            this.config.load(path, false);
            if (this.config.isLoaded()) {
                return ActionResult.success();
            }
            return ActionResult.fail((Component)Component.translatable((String)"configured.gui.load_world_config_failed"));
        }
        return ActionResult.success();
    }

    @Override
    public boolean isReadOnly() {
        return this.config.isReadOnly();
    }

    @Override
    public boolean isChanged() {
        return this.config.isChanged();
    }

    @Override
    public Optional<Runnable> restoreDefaultsTask() {
        if (this.config.isReadOnly()) {
            return Optional.empty();
        }
        if (FrameworkConfigHelper.isWorldType(this.config) && !this.config.isLoaded()) {
            return Optional.empty();
        }
        if (this.config.getType().isServer() && ConfigHelper.isPlayingOnRemoteServer()) {
            return Optional.empty();
        }
        return Optional.of(() -> ((FrameworkConfigManager.FrameworkConfigImpl)this.config).restoreDefaults());
    }

    @Override
    public void startEditing() {
        if (!ConfigHelper.isPlayingGame() && ConfigHelper.isServerConfig(this)) {
            this.config.load(Services.CONFIG.getConfigPath(), false);
        }
    }

    @Override
    public void stopEditing(boolean changed) {
        if (this.config.getConfig() == null) {
            return;
        }
        if (!this.getType().isServer()) {
            return;
        }
        if (ConfigHelper.isPlayingGame() && (ConfigHelper.isIntegratedServer() || this.getType().isSync())) {
            return;
        }
        this.config.unload(false);
    }

    @Override
    public Optional<Runnable> requestFromServerTask() {
        if (this.config.getType().isServer() && !this.config.getType().isSync() && this.config.getType().getEnv().stream().noneMatch(com.mrcrayfish.framework.api.Environment::isDedicatedServer)) {
            return Optional.of(() -> com.mrcrayfish.configured.platform.Services.PLATFORM.sendFrameworkConfigRequest(this.config.getName()));
        }
        return Optional.empty();
    }

    @Override
    public ActionResult canPlayerEdit(@Nullable Player player) {
        ExecutionContext context = new ExecutionContext(player);
        if (context.isClient()) {
            return switch (this.getType()) {
                default -> throw new MatchException(null, null);
                case ConfigType.DEDICATED_SERVER -> ActionResult.fail();
                case ConfigType.CLIENT, ConfigType.UNIVERSAL, ConfigType.MEMORY -> {
                    if (context.isMainMenu() || context.isLocalPlayer()) {
                        yield ActionResult.success();
                    }
                    yield ActionResult.fail();
                }
                case ConfigType.SERVER, ConfigType.WORLD, ConfigType.SERVER_SYNC, ConfigType.WORLD_SYNC -> {
                    if (context.isMainMenu() || context.isSingleplayer()) {
                        yield ActionResult.success();
                    }
                    if (context.isPlayingOnLan()) {
                        if (context.isIntegratedServerOwnedByPlayer()) {
                            yield ActionResult.success();
                        }
                        yield ActionResult.fail((Component)Component.translatable((String)"configured.gui.lan_server"));
                    }
                    if (context.isPlayingOnRemoteServer()) {
                        if (context.isPlayerAnOperator() && context.isDeveloperPlayer()) {
                            yield ActionResult.success();
                        }
                        yield ActionResult.fail((Component)Component.translatable((String)"configured.gui.no_developer_status"));
                    }
                    yield ActionResult.fail((Component)Component.translatable((String)"configured.gui.no_permission"));
                }
            };
        }
        if (context.isDedicatedServer()) {
            return switch (this.getType()) {
                default -> throw new MatchException(null, null);
                case ConfigType.DEDICATED_SERVER, ConfigType.CLIENT, ConfigType.UNIVERSAL, ConfigType.MEMORY -> ActionResult.fail();
                case ConfigType.SERVER, ConfigType.WORLD, ConfigType.SERVER_SYNC, ConfigType.WORLD_SYNC -> context.isPlayerAnOperator() && context.isDeveloperPlayer() ? ActionResult.success() : ActionResult.fail();
            };
        }
        return ActionResult.fail();
    }

    private void syncToServer() {
        if (com.mrcrayfish.configured.platform.Services.PLATFORM.getEnvironment() != Environment.CLIENT) {
            return;
        }
        if (this.config.getConfig() == null) {
            return;
        }
        if (!ConfigHelper.isPlayingGame()) {
            return;
        }
        if (!ConfigHelper.isConfiguredInstalledOnServer()) {
            return;
        }
        if (!this.getType().isServer() || this.getType() == ConfigType.DEDICATED_SERVER) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        Player player = ConfigHelper.getClientPlayer();
        if (!ConfigHelper.isOperator(player) || !ClientSessionData.isDeveloper()) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TomlFormat.instance().createWriter().write(this.config.getConfig(), (OutputStream)stream);
        com.mrcrayfish.configured.platform.Services.PLATFORM.sendFrameworkConfigToServer(this.config.getName(), stream.toByteArray());
    }

    public boolean loadDataFromResponse(MessageFramework.Response message) {
        return this.config.loadFromData(message.data());
    }

    public static class PropertyMap
    implements FrameworkConfigManager.IMapEntry {
        private final Map<String, FrameworkConfigManager.IMapEntry> map = new HashMap<String, FrameworkConfigManager.IMapEntry>();
        private final FrameworkConfigManager.FrameworkConfigImpl config;
        private final List<String> path;

        private PropertyMap(FrameworkConfigManager.FrameworkConfigImpl config, List<String> path) {
            this.config = config;
            this.path = path;
        }

        private PropertyMap(FrameworkConfigManager.FrameworkConfigImpl config) {
            this.config = config;
            this.path = new ArrayList<String>();
            config.getAllProperties().forEach(p -> {
                PropertyMap current = this;
                List path = p.getPath();
                for (int i = 0; i < path.size() - 1; ++i) {
                    int finalI = i + 1;
                    current = (PropertyMap)current.map.computeIfAbsent((String)path.get(i), s -> new PropertyMap(config, path.subList(0, finalI)));
                }
                current.map.put((String)path.get(path.size() - 1), (FrameworkConfigManager.IMapEntry)p);
            });
        }

        public List<Pair<String, PropertyMap>> getConfigMaps() {
            return this.map.entrySet().stream().filter(entry -> entry.getValue() instanceof PropertyMap).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((PropertyMap)entry.getValue()))).toList();
        }

        public List<AbstractProperty<?>> getConfigProperties() {
            ArrayList properties = new ArrayList();
            this.map.forEach((name, entry) -> {
                if (entry instanceof AbstractProperty) {
                    AbstractProperty property = (AbstractProperty)entry;
                    properties.add(property);
                }
            });
            return properties;
        }

        @Nullable
        public String getComment() {
            if (this.path != null && !this.path.isEmpty()) {
                return this.config.getComments().getComment(this.path);
            }
            return null;
        }

        public List<String> getPath() {
            return this.path;
        }

        public String getTranslationKey() {
            if (this.path == null || this.path.isEmpty()) {
                return String.format("config.%s.%s", this.config.getName().getNamespace(), this.config.getName().getPath());
            }
            return String.format("config.%s.%s.%s", this.config.getName().getNamespace(), this.config.getName().getPath(), StringUtils.join(this.path, (char)'.'));
        }
    }
}

