/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record BossStats(float enchantChance, EnchantmentLevels enchLevels, List<ChancedEffectInstance> effects, List<RandomAttributeModifier> modifiers) {
    public static final Codec<BossStats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("enchant_chance").forGetter(BossStats::enchantChance), (App)EnchantmentLevels.CODEC.fieldOf("enchantment_levels").forGetter(BossStats::enchLevels), (App)ChancedEffectInstance.CODEC.listOf().optionalFieldOf("effects", List.of()).forGetter(BossStats::effects), (App)RandomAttributeModifier.CODEC.listOf().optionalFieldOf("attribute_modifiers", List.of()).forGetter(BossStats::modifiers)).apply((Applicative)inst, BossStats::new));

    public static Builder builder() {
        return new Builder();
    }

    public record EnchantmentLevels(int primary, int secondary) {
        public static final Codec<EnchantmentLevels> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("primary").forGetter(EnchantmentLevels::primary), (App)Codec.INT.fieldOf("secondary").forGetter(EnchantmentLevels::secondary)).apply((Applicative)inst, EnchantmentLevels::new));
    }

    public static class Builder {
        private float enchantChance = 0.0f;
        private EnchantmentLevels enchLevels;
        private List<ChancedEffectInstance> effects = new ArrayList<ChancedEffectInstance>();
        private List<RandomAttributeModifier> modifiers = new ArrayList<RandomAttributeModifier>();

        public Builder enchantChance(float enchantChance) {
            this.enchantChance = enchantChance;
            return this;
        }

        public Builder enchLevels(int primary, int secondary) {
            this.enchLevels = new EnchantmentLevels(primary, secondary);
            return this;
        }

        public Builder effect(ChancedEffectInstance effect) {
            this.effects.add(effect);
            return this;
        }

        public Builder effect(float chance, Holder<MobEffect> effect) {
            return this.effect(chance, effect, StepFunction.constant((float)1.0f));
        }

        public Builder effect(float chance, Holder<MobEffect> effect, StepFunction amplifier) {
            return this.effect(new ChancedEffectInstance(chance, effect, amplifier, true, false));
        }

        public Builder modifier(Holder<Attribute> attribute, AttributeModifier.Operation operation, float min, float max) {
            return this.modifier(attribute, operation, StepFunction.fromBounds((float)min, (float)max));
        }

        public Builder modifier(Holder<Attribute> attribute, AttributeModifier.Operation operation, StepFunction value) {
            this.modifiers.add(new RandomAttributeModifier(attribute, operation, value));
            return this;
        }

        public BossStats build() {
            if (this.enchLevels == null) {
                throw new IllegalStateException("EnchantmentLevels must be set");
            }
            return new BossStats(this.enchantChance, this.enchLevels, this.effects, this.modifiers);
        }
    }
}

