/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.spawner.RogueSpawner;
import dev.shadowsoffire.apotheosis.spawner.RogueSpawnerRegistry;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.EntityType;

public class RogueSpawnerProvider
extends DynamicRegistryProvider<RogueSpawner> {
    public RogueSpawnerProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)RogueSpawnerRegistry.INSTANCE);
    }

    public String getName() {
        return "Rogue Spawners";
    }

    public void generate() {
        this.add("brutal/zombie", b -> b.lootTable(Apoth.LootTables.SPAWNER_BRUTAL).weight(30).stats(c -> c.stat(SpawnerStats.MIN_DELAY, 200).stat(SpawnerStats.MAX_DELAY, 400).stat(SpawnerStats.SPAWN_COUNT, 3).stat(SpawnerStats.MAX_NEARBY_ENTITIES, 6).stat(SpawnerStats.SPAWN_RANGE, 5).stat(SpawnerStats.REQ_PLAYER_RANGE, 12)).spawnData(10, RogueSpawnerProvider.brutalZombie()));
        this.add("brutal/husk", b -> b.lootTable(Apoth.LootTables.SPAWNER_BRUTAL).weight(20).stats(c -> c.stat(SpawnerStats.MIN_DELAY, 200).stat(SpawnerStats.MAX_DELAY, 400).stat(SpawnerStats.SPAWN_COUNT, 3).stat(SpawnerStats.MAX_NEARBY_ENTITIES, 6).stat(SpawnerStats.SPAWN_RANGE, 5).stat(SpawnerStats.REQ_PLAYER_RANGE, 12)).spawnData(10, RogueSpawnerProvider.brutalHusk()));
        this.add("brutal/pillager", b -> b.lootTable(Apoth.LootTables.SPAWNER_BRUTAL).weight(20).stats(c -> c.stat(SpawnerStats.MIN_DELAY, 200).stat(SpawnerStats.MAX_DELAY, 400).stat(SpawnerStats.SPAWN_COUNT, 2).stat(SpawnerStats.MAX_NEARBY_ENTITIES, 4).stat(SpawnerStats.SPAWN_RANGE, 5).stat(SpawnerStats.REQ_PLAYER_RANGE, 12)).spawnData(10, RogueSpawnerProvider.brutalPillager()));
        this.add("brutal/rotating", b -> b.lootTable(Apoth.LootTables.SPAWNER_BRUTAL).weight(10).stats(c -> c.stat(SpawnerStats.MIN_DELAY, 180).stat(SpawnerStats.MAX_DELAY, 400).stat(SpawnerStats.SPAWN_COUNT, 3).stat(SpawnerStats.MAX_NEARBY_ENTITIES, 7).stat(SpawnerStats.SPAWN_RANGE, 5).stat(SpawnerStats.REQ_PLAYER_RANGE, 12)).spawnData(30, RogueSpawnerProvider.brutalZombie()).spawnData(20, RogueSpawnerProvider.brutalHusk()).spawnData(10, RogueSpawnerProvider.brutalPillager()));
        this.add("swarm/spider", b -> b.lootTable(Apoth.LootTables.SPAWNER_SWARM).weight(30).stats(c -> c.stat(SpawnerStats.MIN_DELAY, 50).stat(SpawnerStats.MAX_DELAY, 125).stat(SpawnerStats.SPAWN_COUNT, 2).stat(SpawnerStats.MAX_NEARBY_ENTITIES, 10).stat(SpawnerStats.SPAWN_RANGE, 7).stat(SpawnerStats.REQ_PLAYER_RANGE, 14)).spawnData(10, RogueSpawnerProvider.mobWithSwiftness(EntityType.SPIDER, 0)));
        this.add("swarm/cave_spider", b -> b.lootTable(Apoth.LootTables.SPAWNER_SWARM).weight(20).stats(c -> c.stat(SpawnerStats.MIN_DELAY, 50).stat(SpawnerStats.MAX_DELAY, 125).stat(SpawnerStats.SPAWN_COUNT, 2).stat(SpawnerStats.MAX_NEARBY_ENTITIES, 10).stat(SpawnerStats.SPAWN_RANGE, 7).stat(SpawnerStats.REQ_PLAYER_RANGE, 14)).spawnData(10, RogueSpawnerProvider.mobWithSwiftness(EntityType.CAVE_SPIDER, 0)));
        this.add("swarm/silverfish", b -> b.lootTable(Apoth.LootTables.SPAWNER_SWARM).weight(20).stats(c -> c.stat(SpawnerStats.MIN_DELAY, 50).stat(SpawnerStats.MAX_DELAY, 125).stat(SpawnerStats.SPAWN_COUNT, 2).stat(SpawnerStats.MAX_NEARBY_ENTITIES, 10).stat(SpawnerStats.SPAWN_RANGE, 7).stat(SpawnerStats.REQ_PLAYER_RANGE, 14)).spawnData(10, RogueSpawnerProvider.mobWithSwiftness(EntityType.SILVERFISH, 0)));
        this.add("swarm/fast_cave_spider", b -> b.lootTable(Apoth.LootTables.SPAWNER_SWARM).weight(10).stats(c -> c.stat(SpawnerStats.MIN_DELAY, 50).stat(SpawnerStats.MAX_DELAY, 125).stat(SpawnerStats.SPAWN_COUNT, 2).stat(SpawnerStats.MAX_NEARBY_ENTITIES, 10).stat(SpawnerStats.SPAWN_RANGE, 7).stat(SpawnerStats.REQ_PLAYER_RANGE, 14)).spawnData(10, RogueSpawnerProvider.mobWithSwiftness(EntityType.CAVE_SPIDER, 2)));
        this.add("swarm/baby_zombie", b -> b.lootTable(Apoth.LootTables.SPAWNER_SWARM).weight(10).stats(c -> c.stat(SpawnerStats.MIN_DELAY, 50).stat(SpawnerStats.MAX_DELAY, 125).stat(SpawnerStats.SPAWN_COUNT, 2).stat(SpawnerStats.MAX_NEARBY_ENTITIES, 10).stat(SpawnerStats.SPAWN_RANGE, 7).stat(SpawnerStats.REQ_PLAYER_RANGE, 14).stat(SpawnerStats.YOUTHFUL, true)).spawnData(10, RogueSpawnerProvider.mobWithSwiftness(EntityType.ZOMBIE, 1)));
    }

    private void add(String path, UnaryOperator<RogueSpawner.Builder> builder) {
        this.add(Apotheosis.loc(path), ((RogueSpawner.Builder)builder.apply(RogueSpawner.builder())).build());
    }

    private static CompoundTag brutalHusk() {
        String rawNbt = "{\n    \"Health\": 30.0,\n    \"attributes\": [{\n            \"base\": 0.23,\n            \"modifiers\": [{\n                \"amount\": 0.15,\n                \"operation\": \"add_multiplied_total\",\n                \"id\": \"placebo:brutal_max_spd\"\n            }],\n            \"id\": \"minecraft:generic.movement_speed\"\n        },\n        {\n            \"base\": 3.0,\n            \"modifiers\": [{\n                \"amount\": 0.5,\n                \"operation\": \"add_multiplied_total\",\n                \"id\": \"placebo:brutal_max_dmg\"\n            }],\n            \"id\": \"minecraft:generic.attack_damage\"\n        },\n        {\n            \"base\": 20.0,\n            \"modifiers\": [{\n                \"amount\": 0.5,\n                \"operation\": \"add_multiplied_total\",\n                \"id\": \"placebo:brutal_max_hp\"\n            }],\n            \"id\": \"minecraft:generic.max_health\"\n        }\n    ],\n    \"id\": \"husk\",\n    \"active_effects\": [{\n        \"visible\": false,\n        \"show_particles\": false,\n        \"duration\": 10000000,\n        \"id\": \"minecraft:fire_resistance\",\n        \"amplifier\": 0\n    }]\n}\n";
        return RogueSpawnerProvider.parse(rawNbt);
    }

    private static CompoundTag brutalZombie() {
        String rawNbt = "{\n    \"Health\": 30.0,\n    \"attributes\": [{\n            \"base\": 0.23,\n            \"modifiers\": [{\n                \"amount\": 0.15,\n                \"operation\": \"add_multiplied_total\",\n                \"id\": \"placebo:brutal_max_spd\"\n            }],\n            \"id\": \"minecraft:generic.movement_speed\"\n        },\n        {\n            \"base\": 3.0,\n            \"modifiers\": [{\n                \"amount\": 0.5,\n                \"operation\": \"add_multiplied_total\",\n                \"id\": \"placebo:brutal_max_dmg\"\n            }],\n            \"id\": \"minecraft:generic.attack_damage\"\n        },\n        {\n            \"base\": 20.0,\n            \"modifiers\": [{\n                \"amount\": 0.5,\n                \"operation\": \"add_multiplied_total\",\n                \"id\": \"placebo:brutal_max_hp\"\n            }],\n            \"id\": \"minecraft:generic.max_health\"\n        }\n    ],\n    \"id\": \"zombie\",\n    \"active_effects\": [{\n        \"visible\": false,\n        \"show_particles\": false,\n        \"duration\": 10000000,\n        \"id\": \"minecraft:fire_resistance\",\n        \"amplifier\": 0\n    }]\n}\n";
        return RogueSpawnerProvider.parse(rawNbt);
    }

    private static CompoundTag brutalPillager() {
        String rawNbt = "{\n    \"Health\": 36.0,\n    \"attributes\": [{\n            \"base\": 0.35,\n            \"modifiers\": [{\n                \"amount\": 0.15,\n                \"operation\": \"add_multiplied_total\",\n                \"id\": \"placebo:brutal_max_spd\"\n            }],\n            \"id\": \"minecraft:generic.movement_speed\"\n        },\n        {\n            \"base\": 1.0,\n            \"modifiers\": [{\n                \"amount\": 0.3,\n                \"operation\": \"add_multiplied_total\",\n                \"id\": \"placebo:brutal_max_dmg\"\n            }],\n            \"id\": \"apothic_attributes:projectile_damage\"\n        },\n        {\n            \"base\": 24.0,\n            \"modifiers\": [{\n                \"amount\": 0.5,\n                \"operation\": \"add_multiplied_total\",\n                \"id\": \"placebo:brutal_max_hp\"\n            }],\n            \"id\": \"minecraft:generic.max_health\"\n        }\n    ],\n    \"id\": \"pillager\",\n    \"active_effects\": [{\n        \"visible\": false,\n        \"show_particles\": false,\n        \"duration\": 10000000,\n        \"id\": \"minecraft:fire_resistance\",\n        \"amplifier\": 0\n    }],\n    \"HandItems\": [{\n            \"id\": \"minecraft:crossbow\",\n            \"Count\": 1\n        },\n        {}\n    ]\n}\n";
        return RogueSpawnerProvider.parse(rawNbt);
    }

    private static CompoundTag mobWithSwiftness(EntityType<?> type, int amplifier) {
        String rawNbt = "{\n    \"id\": \"%s\",\n    \"active_effects\": [{\n        \"visible\": false,\n        \"show_particles\": false,\n        \"duration\": 10000000,\n        \"id\": \"minecraft:speed\",\n        \"amplifier\": %d\n    }]\n}\n".formatted(BuiltInRegistries.ENTITY_TYPE.getKey(type), amplifier);
        return RogueSpawnerProvider.parse(rawNbt);
    }

    private static CompoundTag parse(String str) {
        try {
            return TagParser.parseTag((String)str);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

