/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apotheosis.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import java.util.Arrays;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GemCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_OP = (ctx, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(AttributeModifier.Operation.values()).map(Enum::name), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_ATTRIB = (ctx, builder) -> SharedSuggestionProvider.suggest(BuiltInRegistries.ATTRIBUTE.keySet().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_GEM = (ctx, builder) -> SharedSuggestionProvider.suggest(GemRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gem").requires(c -> c.hasPermission(2))).then(Commands.literal((String)"fromPreset").then(Commands.argument((String)"gem", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_GEM).executes(c -> {
            Gem gem = (Gem)GemRegistry.INSTANCE.getValue(ResourceLocationArgument.getId((CommandContext)c, (String)"gem"));
            ServerPlayer p = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            GenContext ctx = GenContext.forPlayer((Player)p);
            ItemStack stack = gem.toStack(Purity.random(ctx));
            p.addItem(stack);
            return 0;
        })))).then(Commands.literal((String)"random").executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            GenContext ctx = GenContext.forPlayer((Player)p);
            ItemStack gem = GemRegistry.createRandomGemStack(ctx);
            p.addItem(gem);
            return 0;
        })));
    }
}

