/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.salvaging;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingMenu;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class SalvagingTableTile
extends BlockEntity {
    protected final InternalItemHandler output = new InternalItemHandler(6);
    protected final IItemHandler itemHandler = new SalvagingItemHandler();

    public SalvagingTableTile(BlockPos pPos, BlockState pBlockState) {
        super(Apoth.Tiles.SALVAGING_TABLE, pPos, pBlockState);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        tag.put("output", (Tag)this.output.serializeNBT(regs));
        super.saveAdditional(tag, regs);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        if (tag.contains("output")) {
            this.output.deserializeNBT(regs, tag.getCompound("output"));
        }
        super.loadAdditional(tag, regs);
    }

    protected class SalvagingItemHandler
    implements IItemHandler {
        protected SalvagingItemHandler() {
        }

        public int getSlots() {
            return 1 + SalvagingTableTile.this.output.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return ItemStack.EMPTY;
            }
            return SalvagingTableTile.this.output.getStackInSlot(slot - 1);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int i;
            if (slot != 0) {
                return stack;
            }
            List<ItemStack> outputs = SalvagingMenu.getSalvageResults(SalvagingTableTile.this.level, stack);
            if (outputs.isEmpty()) {
                return stack;
            }
            IntOpenHashSet skipSlots = new IntOpenHashSet();
            for (ItemStack out : outputs) {
                for (i = 0; i < 6; ++i) {
                    if (skipSlots.contains(i)) continue;
                    int size = out.getCount();
                    if (size != (out = SalvagingTableTile.this.output.insertItem(i, out, true)).getCount()) {
                        skipSlots.add(i);
                    }
                    if (out.isEmpty()) break;
                }
                if (out.isEmpty()) continue;
                return stack;
            }
            if (!simulate) {
                for (ItemStack out : outputs) {
                    for (i = 0; i < 6 && !(out = SalvagingTableTile.this.output.insertItem(i, out, false)).isEmpty(); ++i) {
                    }
                    if (out.isEmpty()) continue;
                    return stack;
                }
            }
            return stack.copyWithCount(stack.getCount() - 1);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                return ItemStack.EMPTY;
            }
            return SalvagingTableTile.this.output.extractItem(slot - 1, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 1;
            }
            return SalvagingTableTile.this.output.getSlotLimit(slot - 1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return !SalvagingMenu.findMatch(SalvagingTableTile.this.level, stack).isEmpty();
            }
            return false;
        }
    }
}

