/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.compressor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class CompressedRecipeRegistry {
    private final List<CompressedRecipe> recipesSmall = new ArrayList<CompressedRecipe>();
    private final List<CompressedRecipe> recipes = new ArrayList<CompressedRecipe>();
    private final Map<ResourceLocation, CompressedRecipe> cachedResults = new HashMap<ResourceLocation, CompressedRecipe>();

    public void reloadRecipes(RecipeManager recipeManager, RegistryAccess registryAccess) {
        this.cachedResults.clear();
        this.recipesSmall.clear();
        this.recipes.clear();
        for (RecipeHolder recipeHolder : recipeManager.getAllRecipesFor(RecipeType.CRAFTING)) {
            CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
            NonNullList ingredients = recipe.getIngredients();
            int count = ingredients.size();
            if (count != 4 && count != 9) continue;
            Ingredient first = (Ingredient)ingredients.getFirst();
            boolean passes = true;
            for (int i = 1; i < count; ++i) {
                Ingredient other = (Ingredient)ingredients.get(i);
                boolean passesInner = false;
                for (ItemStack itemStack : other.getItems()) {
                    if (!first.test(itemStack)) continue;
                    passesInner = true;
                    break;
                }
                if (passesInner) continue;
                passes = false;
                break;
            }
            if (count == 4 && recipe.canCraftInDimensions(2, 2)) {
                if (!passes) continue;
                this.recipesSmall.add(new CompressedRecipe(first, 4, recipe.getResultItem((HolderLookup.Provider)registryAccess).copy()));
                continue;
            }
            if (count != 9 || !recipe.canCraftInDimensions(3, 3) || !passes) continue;
            this.recipes.add(new CompressedRecipe(first, 9, recipe.getResultItem((HolderLookup.Provider)registryAccess).copy()));
        }
    }

    @Nullable
    public CompressedRecipe getRecipe(ItemStack itemStack) {
        if (!itemStack.getComponentsPatch().isEmpty()) {
            return null;
        }
        ResourceLocation registryName = Balm.getRegistries().getKey(itemStack.getItem());
        CompressedRecipe foundRecipe = this.cachedResults.get(registryName);
        if (foundRecipe != null) {
            return foundRecipe;
        }
        for (CompressedRecipe recipe : this.recipes) {
            if (!recipe.getIngredient().test(itemStack)) continue;
            this.cachedResults.put(registryName, recipe);
            return recipe;
        }
        for (CompressedRecipe recipe : this.recipesSmall) {
            if (!recipe.getIngredient().test(itemStack)) continue;
            this.cachedResults.put(registryName, recipe);
            return recipe;
        }
        this.cachedResults.put(registryName, null);
        return null;
    }
}

