/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.autosieveskin;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.registry.autosieveskin.WhitelistEntry;
import org.jetbrains.annotations.Nullable;

public class AutoSieveSkinRegistry {
    private static final Random random = new Random();
    private static final List<WhitelistEntry> availableSkins = new ArrayList<WhitelistEntry>();

    public static void load() {
        if (!ExCompressumConfig.getActive().client.skipAutoSieveSkins) {
            availableSkins.clear();
            Thread loadAutoSieveSkins = new Thread(() -> {
                try {
                    URL remoteURL = new URL("https://whitelist.blay09.net/api/whitelists/BlayTheNinth");
                    InputStream in = remoteURL.openStream();
                    Gson gson = new Gson();
                    JsonReader reader = new JsonReader((Reader)new InputStreamReader(in));
                    List result = (List)gson.fromJson(reader, new TypeToken<List<WhitelistEntry>>(){}.getType());
                    List<WhitelistEntry> list = availableSkins;
                    synchronized (list) {
                        availableSkins.addAll(result);
                    }
                    reader.close();
                }
                catch (Throwable e) {
                    ExCompressum.logger.error("Could not load remote skins for auto sieve: ", e);
                }
            });
            loadAutoSieveSkins.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static WhitelistEntry getRandomSkin() {
        List<WhitelistEntry> list = availableSkins;
        synchronized (list) {
            if (availableSkins.isEmpty()) {
                return null;
            }
            return availableSkins.get(random.nextInt(availableSkins.size()));
        }
    }
}

