/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.menu;

import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.menu.OutputSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AutoSieveMenu
extends AbstractContainerMenu {
    private final AbstractAutoSieveBlockEntity autoSieve;

    public AutoSieveMenu(MenuType<AutoSieveMenu> type, int windowId, Inventory inventory, AbstractAutoSieveBlockEntity autoSieve) {
        super(type, windowId);
        int j;
        int i;
        this.autoSieve = autoSieve;
        Container container = autoSieve.getBackingContainer();
        this.addSlot(new Slot(container, 0, 8, 22));
        this.addSlot(new Slot(container, 21, 8, 49));
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 5; ++j) {
                this.addSlot(new OutputSlot(container, 1 + i * 5 + j, 57 + j * 18, 8 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
        this.addDataSlots(autoSieve.getContainerData());
    }

    public boolean stillValid(Player player) {
        return this.autoSieve.isUsableByPlayer(player);
    }

    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (slotNumber <= 21 ? !this.moveItemStackTo(slotStack, 22, 58, true) : (this.autoSieve.getBackingContainer().canPlaceItem(0, slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, false) : this.autoSieve.getBackingContainer().canPlaceItem(21, slotStack) && !this.moveItemStackTo(slotStack, 1, 2, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    public AbstractAutoSieveBlockEntity getAutoSieve() {
        return this.autoSieve;
    }
}

