/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.item;

import java.util.List;
import net.blay09.mods.excompressum.api.ExCompressumAPI;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class OreSmasherItem
extends DiggerItem {
    public OreSmasherItem(Item.Properties properties) {
        super((Tier)Tiers.DIAMOND, BlockTags.MINEABLE_WITH_SHOVEL, properties);
    }

    public boolean isCorrectToolForDrops(ItemStack itemStack, BlockState state) {
        return ExCompressumAPI.getExNihilo().isHammerableOre(new ItemStack((ItemLike)state.getBlock()));
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (ExCompressumAPI.getExNihilo().isHammerableOre(new ItemStack((ItemLike)state.getBlock()))) {
            return this.getTier().getSpeed();
        }
        return 0.8f;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            CompressedRecipe recipe;
            ItemStack inventoryStack = (ItemStack)player.getInventory().items.get(i);
            if (inventoryStack.isEmpty()) continue;
            if (ExCompressumAPI.getExNihilo().isCompressableOre(inventoryStack) && (recipe = ExRegistries.getCompressedRecipeRegistry().getRecipe(inventoryStack)) != null && recipe.getResultStack().getCount() == 1 && inventoryStack.getCount() >= recipe.getCount()) {
                BlockState oldState = level.getBlockState(pos);
                ItemStack resultStack = recipe.getResultStack().copy();
                resultStack.getItem().useOn(new UseOnContext(player, context.getHand(), new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside())));
                level.sendBlockUpdated(pos, oldState, level.getBlockState(pos), 3);
                if (resultStack.isEmpty()) {
                    inventoryStack.shrink(recipe.getCount());
                    if (inventoryStack.isEmpty()) {
                        player.getInventory().items.remove(i);
                    }
                    player.swing(context.getHand());
                    return InteractionResult.SUCCESS;
                }
            }
            if (!ExCompressumAPI.getExNihilo().isHammerableOre(inventoryStack)) continue;
            BlockState oldState = level.getBlockState(pos);
            inventoryStack.getItem().useOn(new UseOnContext(player, context.getHand(), new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside())));
            level.sendBlockUpdated(pos, oldState, level.getBlockState(pos), 3);
            if (inventoryStack.isEmpty()) {
                player.getInventory().items.remove(i);
            }
            player.swing(context.getHand());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean mineBlock(ItemStack itemStack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!level.isClientSide && this.isCorrectToolForDrops(itemStack, state) && ExNihilo.getInstance().isHammerable(level, state)) {
            level.removeBlock(pos, false);
            List<ItemStack> rewards = ExNihilo.getInstance().rollHammerRewards(level, state, itemStack, level.random);
            for (ItemStack rewardStack : rewards) {
                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, rewardStack));
            }
        }
        return super.mineBlock(itemStack, level, state, pos, entityLiving);
    }
}

