/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.item;

import java.util.List;
import net.blay09.mods.excompressum.CommonProxy;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.component.ModComponents;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.item.ChickenStickTier;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.tag.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class ChickenStickItem
extends DiggerItem {
    public ChickenStickItem(Item.Properties properties) {
        super((Tier)ChickenStickTier.INSTANCE, ModBlockTags.MINEABLE_WITH_HAMMER, properties.fireResistant());
    }

    public boolean hurtEnemy(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        this.tryPlayChickenSound((LevelAccessor)attacker.level(), attacker.blockPosition());
        return super.hurtEnemy(itemStack, attacker, target);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        this.tryPlayChickenSound((LevelAccessor)level, player.blockPosition());
        player.swing(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public boolean isCorrectToolForDrops(ItemStack itemStack, BlockState state) {
        RecipeManager recipeManager = ((CommonProxy)ExCompressum.proxy.get()).getRecipeManager(null);
        return ExRegistries.getChickenStickRegistry().isHammerable(recipeManager, new ItemStack((ItemLike)state.getBlock()));
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        RecipeManager recipeManager = ((CommonProxy)ExCompressum.proxy.get()).getRecipeManager(null);
        if (ExRegistries.getChickenStickRegistry().isHammerable(recipeManager, new ItemStack((ItemLike)state.getBlock()))) {
            if (this.isAngry(stack)) {
                return this.getTier().getSpeed() * 1.5f;
            }
            return this.getTier().getSpeed();
        }
        return 0.8f;
    }

    public void tryPlayChickenSound(LevelAccessor level, BlockPos pos) {
        if ((double)level.getRandom().nextFloat() <= ExCompressumConfig.getActive().tools.chickenStickSoundChance) {
            ResourceLocation location = null;
            List<String> chickenStickSounds = ExCompressumConfig.getActive().tools.chickenStickSounds;
            if (!chickenStickSounds.isEmpty()) {
                location = ResourceLocation.parse((String)chickenStickSounds.get(level.getRandom().nextInt(chickenStickSounds.size())));
            }
            if (location != null) {
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(location);
                if (soundEvent != null) {
                    level.playSound(null, pos, soundEvent, SoundSource.PLAYERS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                } else {
                    ExCompressum.logger.warn("Chicken Stick tried to play a sound that does not exist: {}", (Object)location);
                }
            }
        }
    }

    public boolean isFoil(ItemStack stack) {
        return this.isAngry(stack);
    }

    public boolean isAngry(ItemStack itemStack) {
        return itemStack.has((DataComponentType)ModComponents.angry.get());
    }
}

