/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.item;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class BatZapperItem
extends Item {
    public BatZapperItem(Item.Properties properties) {
        super(properties.durability(Tiers.STONE.getUses()));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        if (context.getPlayer() != null && context.getPlayer().getAbilities().instabuild && (blockEntity = context.getLevel().getBlockEntity(context.getClickedPos())) != null) {
            if (blockEntity instanceof BalmEnergyStorageProvider) {
                BalmEnergyStorageProvider energyStorageProvider = (BalmEnergyStorageProvider)blockEntity;
                EnergyStorage energyStorage = energyStorageProvider.getEnergyStorage();
                if (energyStorage != null) {
                    energyStorage.setEnergy(energyStorage.getCapacity());
                }
            } else {
                EnergyStorage energyStorage = (EnergyStorage)Balm.getProviders().getProvider(blockEntity, EnergyStorage.class);
                if (energyStorage != null) {
                    energyStorage.setEnergy(energyStorage.getCapacity());
                }
            }
        }
        return this.zapBatter(context.getLevel(), context.getPlayer(), context.getItemInHand(), context.getClickedPos(), context.getHand()).getResult();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return this.zapBatter(level, player, player.getItemInHand(hand), player.blockPosition(), hand);
    }

    private InteractionResultHolder<ItemStack> zapBatter(Level level, Player player, ItemStack itemStack, BlockPos pos, InteractionHand hand) {
        level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.PLAYERS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
        player.swing(hand);
        if (!level.isClientSide) {
            int range = 5;
            for (Bat entity : level.getEntitiesOfClass(Bat.class, new AABB((double)(pos.getX() - 5), (double)(pos.getY() - 5), (double)(pos.getZ() - 5), (double)(pos.getX() + 5), (double)(pos.getY() + 5), (double)(pos.getZ() + 5)))) {
                entity.hurt(level.damageSources().playerAttack(player), Float.MAX_VALUE);
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, entity.getX(), entity.getY(), entity.getZ(), 50, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.1f);
            }
        }
        itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }
}

