/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.EntityAddedEvent;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CompressedEnemyHandler {
    private static final String COMPRESSED = "Compressed";
    private static final String NOCOMPRESS = "NoCompress";

    public static void initialize() {
        Balm.getEvents().onEvent(EntityAddedEvent.class, CompressedEnemyHandler::onEntityAdded);
        Balm.getEvents().onEvent(LivingDeathEvent.class, CompressedEnemyHandler::onLivingDeath);
    }

    public static void onEntityAdded(EntityAddedEvent event) {
        Level level = event.getLevel();
        Entity entity = event.getEntity();
        if (!level.isClientSide && (entity instanceof Mob || entity instanceof Ghast)) {
            boolean isWhitelist;
            CompoundTag persistentData = Balm.getHooks().getPersistentData(entity);
            ResourceLocation registryName = Balm.getRegistries().getKey(entity.getType());
            boolean bl = isWhitelist = !ExCompressumConfig.getActive().compressedMobs.compressedMobAllowedMobsIsBlacklist;
            if (registryName != null && ExCompressumConfig.getActive().compressedMobs.compressedMobAllowedMobs.contains(registryName.toString()) == isWhitelist) {
                CompoundTag baseTag = persistentData.getCompound("excompressum");
                if (baseTag.contains(NOCOMPRESS) || baseTag.contains(COMPRESSED)) {
                    return;
                }
                if ((double)level.random.nextFloat() < ExCompressumConfig.getActive().compressedMobs.compressedMobChance) {
                    entity.setCustomNameVisible(true);
                    entity.setCustomName((Component)Component.translatable((String)"tooltip.excompressum.compressed_mob", (Object[])new Object[]{entity.getName()}));
                    CompoundTag tagCompound = new CompoundTag();
                    tagCompound.putBoolean(COMPRESSED, true);
                    persistentData.put("excompressum", (Tag)tagCompound);
                } else {
                    CompoundTag tagCompound = new CompoundTag();
                    tagCompound.putBoolean(NOCOMPRESS, true);
                    persistentData.put("excompressum", (Tag)tagCompound);
                }
            }
        }
    }

    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        Level level = entity2.level();
        DamageSource damageSource = event.getDamageSource();
        CompoundTag persistentData = Balm.getHooks().getPersistentData((Entity)entity2);
        if (!level.isClientSide && persistentData.getCompound("excompressum").contains(COMPRESSED) && (entity2 instanceof Mob || entity2 instanceof Ghast) && (entity = damageSource.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!Balm.getHooks().isFakePlayer(player)) {
                if (StupidUtils.hasSilkTouchModifier((LivingEntity)damageSource.getEntity())) {
                    return;
                }
                EntityType entityType = entity2.getType();
                for (int i = 0; i < ExCompressumConfig.getActive().compressedMobs.compressedMobSize; ++i) {
                    LivingEntity newEntity = (LivingEntity)entityType.create((ServerLevel)level, null, entity2.blockPosition(), MobSpawnType.CONVERSION, false, false);
                    if (newEntity == null) {
                        return;
                    }
                    if (entity2.isBaby()) {
                        if (newEntity instanceof Zombie) {
                            Zombie zombie = (Zombie)newEntity;
                            zombie.setBaby(true);
                        } else if (newEntity instanceof AgeableMob) {
                            AgeableMob mob = (AgeableMob)newEntity;
                            if (entity2 instanceof AgeableMob) {
                                AgeableMob from = (AgeableMob)entity2;
                                mob.setAge(from.getAge());
                            }
                        }
                    }
                    if (newEntity instanceof ZombifiedPiglin) {
                        newEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.GOLDEN_SWORD));
                    } else if (newEntity instanceof Skeleton) {
                        newEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
                    } else if (newEntity instanceof WitherSkeleton) {
                        newEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
                    }
                    CompoundTag tagCompound = new CompoundTag();
                    tagCompound.putBoolean(NOCOMPRESS, true);
                    Balm.getHooks().getPersistentData((Entity)newEntity).put("excompressum", (Tag)tagCompound);
                    newEntity.moveTo(entity2.getX(), entity2.getY() + 1.0, entity2.getZ(), (float)Math.random(), (float)Math.random());
                    double motion = 0.01;
                    newEntity.setDeltaMovement((level.random.nextGaussian() - 0.5) * 0.01, 0.0, (level.random.nextGaussian() - 0.5) * 0.01);
                    level.addFreshEntity((Entity)newEntity);
                }
            }
        }
    }
}

