/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.excompressum.api.recipe.CompressedHammerRecipe;
import net.blay09.mods.excompressum.api.recipe.HammerRecipe;
import net.blay09.mods.excompressum.api.recipe.HeavySieveRecipe;
import net.blay09.mods.excompressum.api.recipe.SieveRecipe;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.HeavySieveBlock;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.compat.jei.ChickenStickJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.CompressedHammerJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.CraftChickenStickJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.CraftChickenStickRecipe;
import net.blay09.mods.excompressum.compat.jei.HammerJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.HeavySieveJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.SieveJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.WoodenCrucibleJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedChickenStickRecipe;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedCompressedHammerRecipe;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedHammerRecipe;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedHeavySieveRecipe;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedSieveRecipe;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedWoodenCrucibleRecipe;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ModRecipeTypes;
import net.blay09.mods.excompressum.registry.chickenstick.ChickenStickRecipe;
import net.blay09.mods.excompressum.registry.heavysieve.GeneratedHeavySieveRecipe;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRecipeImpl;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRecipe;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;

@JeiPlugin
public class JEIAddon
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration registry) {
        ArrayList<ExpandedHeavySieveRecipe> expandedHeavySieveRecipes = new ArrayList<ExpandedHeavySieveRecipe>();
        ClientLevel level = Minecraft.getInstance().level;
        RecipeManager recipeManager = level.getRecipeManager();
        List heavySieveRecipes = recipeManager.getAllRecipesFor(ModRecipeTypes.heavySieveRecipeType);
        for (RecipeHolder recipeHolder : heavySieveRecipes) {
            expandedHeavySieveRecipes.add(new ExpandedHeavySieveRecipe(recipeHolder.id(), (HeavySieveRecipe)recipeHolder.value()));
        }
        for (HeavySieveRecipe heavySieveRecipe : ExNihilo.getInstance().getHeavySieveRecipes()) {
            expandedHeavySieveRecipes.add(new ExpandedHeavySieveRecipe(null, heavySieveRecipe));
        }
        List generatedHeavySieveRecipes = recipeManager.getAllRecipesFor(ModRecipeTypes.generatedHeavySieveRecipeType);
        for (Object recipe : generatedHeavySieveRecipes) {
            this.loadGeneratedHeavySieveRecipe((Level)level, false, (GeneratedHeavySieveRecipe)recipe.value(), expandedHeavySieveRecipes);
            this.loadGeneratedHeavySieveRecipe((Level)level, true, (GeneratedHeavySieveRecipe)recipe.value(), expandedHeavySieveRecipes);
        }
        registry.addRecipes(HeavySieveJeiRecipeCategory.TYPE, expandedHeavySieveRecipes);
        ArrayList<ExpandedSieveRecipe> arrayList = new ArrayList<ExpandedSieveRecipe>();
        for (SieveRecipe recipe : ExNihilo.getInstance().getSieveRecipes()) {
            arrayList.add(new ExpandedSieveRecipe(null, recipe));
        }
        registry.addRecipes(SieveJeiRecipeCategory.TYPE, arrayList);
        ArrayList<ExpandedCompressedHammerRecipe> expandedCompressedHammerRecipes = new ArrayList<ExpandedCompressedHammerRecipe>();
        List compressedHammerRecipes = recipeManager.getAllRecipesFor(ModRecipeTypes.compressedHammerRecipeType);
        for (RecipeHolder recipeHolder : compressedHammerRecipes) {
            expandedCompressedHammerRecipes.add(new ExpandedCompressedHammerRecipe(recipeHolder.id(), (CompressedHammerRecipe)recipeHolder.value()));
        }
        for (CompressedHammerRecipe compressedHammerRecipe : ExNihilo.getInstance().getCompressedHammerRecipes()) {
            expandedCompressedHammerRecipes.add(new ExpandedCompressedHammerRecipe(null, compressedHammerRecipe));
        }
        registry.addRecipes(CompressedHammerJeiRecipeCategory.TYPE, expandedCompressedHammerRecipes);
        ArrayList<ExpandedHammerRecipe> expandedHammerRecipes = new ArrayList<ExpandedHammerRecipe>();
        List list = recipeManager.getAllRecipesFor(ModRecipeTypes.hammerRecipeType);
        for (RecipeHolder recipeHolder : list) {
            expandedHammerRecipes.add(new ExpandedHammerRecipe(recipeHolder.id(), (HammerRecipe)recipeHolder.value()));
        }
        for (HammerRecipe hammerRecipe : ExNihilo.getInstance().getHammerRecipes()) {
            expandedHammerRecipes.add(new ExpandedHammerRecipe(null, hammerRecipe));
        }
        registry.addRecipes(HammerJeiRecipeCategory.TYPE, expandedHammerRecipes);
        ArrayList<ExpandedChickenStickRecipe> expandedChickenStickRecipes = new ArrayList<ExpandedChickenStickRecipe>();
        List list2 = recipeManager.getAllRecipesFor(ModRecipeTypes.chickenStickRecipeType);
        for (RecipeHolder recipe : list2) {
            expandedChickenStickRecipes.add(new ExpandedChickenStickRecipe(recipe.id(), (ChickenStickRecipe)recipe.value()));
        }
        registry.addRecipes(ChickenStickJeiRecipeCategory.TYPE, expandedChickenStickRecipes);
        ArrayListMultimap fluidOutputMap = ArrayListMultimap.create();
        List woodenCrucibleRecipes = recipeManager.getAllRecipesFor(ModRecipeTypes.woodenCrucibleRecipeType);
        for (RecipeHolder recipe : woodenCrucibleRecipes) {
            fluidOutputMap.put((Object)((WoodenCrucibleRecipe)recipe.value()).getFluidId(), (Object)((WoodenCrucibleRecipe)recipe.value()));
        }
        ArrayList<ExpandedWoodenCrucibleRecipe> expandedWoodenCrucibleRecipes = new ArrayList<ExpandedWoodenCrucibleRecipe>();
        for (ResourceLocation fluidName : fluidOutputMap.keySet()) {
            Fluid fluid = Balm.getRegistries().getFluid(fluidName);
            if (fluid == null) continue;
            List recipes = fluidOutputMap.get((Object)fluidName);
            ArrayList<Pair> inputs = new ArrayList<Pair>();
            for (WoodenCrucibleRecipe meltable : recipes) {
                for (ItemStack matchingStack : meltable.getIngredient().getItems()) {
                    inputs.add(Pair.of((Object)meltable, (Object)matchingStack));
                }
            }
            inputs.sort(Comparator.comparingInt(pair -> ((WoodenCrucibleRecipe)pair.getFirst()).getAmount()).reversed());
            int pageSize = 45;
            List pages = Lists.partition(inputs, (int)45);
            for (List page : pages) {
                expandedWoodenCrucibleRecipes.add(new ExpandedWoodenCrucibleRecipe(null, fluid, page));
            }
        }
        registry.addRecipes(WoodenCrucibleJeiRecipeCategory.TYPE, expandedWoodenCrucibleRecipes);
        registry.addRecipes(CraftChickenStickJeiRecipeCategory.TYPE, (List)Lists.newArrayList((Object[])new CraftChickenStickRecipe[]{new CraftChickenStickRecipe()}));
    }

    private void loadGeneratedHeavySieveRecipe(Level level, boolean waterlogged, GeneratedHeavySieveRecipe generatedRecipe, List<ExpandedHeavySieveRecipe> outRecipes) {
        BlockState waterLoggedState = (BlockState)ModBlocks.heavySieves[0].defaultBlockState().setValue((Property)HeavySieveBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        for (SieveMeshRegistryEntry mesh : SieveMeshRegistry.getEntries().values()) {
            Integer rolls = HeavySieveRegistry.getGeneratedRollCount(generatedRecipe);
            Item source = Balm.getRegistries().getItem(generatedRecipe.getSourceItem());
            LootTable lootTable = ExNihilo.getInstance().generateHeavySieveLootTable(level, waterLoggedState, (ItemLike)source, rolls, mesh);
            if (LootTableUtils.isLootTableEmpty(lootTable)) continue;
            HeavySieveRecipeImpl recipe = new HeavySieveRecipeImpl(generatedRecipe.getIngredient(), lootTable, waterlogged, List.of(mesh.getMeshType()));
            outRecipes.add(new ExpandedHeavySieveRecipe(null, recipe));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.autoSieve), new RecipeType[]{SieveJeiRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.autoHeavySieve), new RecipeType[]{HeavySieveJeiRecipeCategory.TYPE});
        for (Block heavySieve : ModBlocks.heavySieves) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)heavySieve), new RecipeType[]{HeavySieveJeiRecipeCategory.TYPE});
        }
        for (Block woodenCrucible : ModBlocks.woodenCrucibles) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)woodenCrucible), new RecipeType[]{WoodenCrucibleJeiRecipeCategory.TYPE});
        }
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.chickenStick), new RecipeType[]{ChickenStickJeiRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.autoCompressedHammer), new RecipeType[]{CompressedHammerJeiRecipeCategory.TYPE});
        for (Holder itemHolder : BuiltInRegistries.ITEM.getTagOrEmpty(ModItemTags.COMPRESSED_HAMMERS)) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)itemHolder.value()), new RecipeType[]{CompressedHammerJeiRecipeCategory.TYPE});
        }
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.autoHammer), new RecipeType[]{HammerJeiRecipeCategory.TYPE});
        for (Holder itemHolder : BuiltInRegistries.ITEM.getTagOrEmpty(ModItemTags.HAMMERS)) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)itemHolder.value()), new RecipeType[]{HammerJeiRecipeCategory.TYPE});
        }
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SieveJeiRecipeCategory(registry.getJeiHelpers()), new HeavySieveJeiRecipeCategory(registry.getJeiHelpers()), new HammerJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new CompressedHammerJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new WoodenCrucibleJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new CraftChickenStickJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ChickenStickJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

