/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedHammerRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class HammerJeiRecipeCategory
implements IRecipeCategory<ExpandedHammerRecipe> {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"textures/gui/jei_hammer.png");
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"hammer");
    public static final RecipeType<ExpandedHammerRecipe> TYPE = new RecipeType(UID, ExpandedHammerRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public HammerJeiRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 0, 166, 63);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.autoHammer));
    }

    public RecipeType<ExpandedHammerRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)UID.toString());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayoutBuilder, ExpandedHammerRecipe recipe, IFocusGroup focusGroup) {
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 75, 10).addIngredients(recipe.getIngredient());
        List<ItemStack> outputItems = recipe.getOutputItems();
        for (int i = 0; i < outputItems.size(); ++i) {
            int slotX = 3 + i * 18;
            int slotY = 37;
            recipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, slotX, 37).addItemStack(outputItems.get(i));
        }
    }

    @Nullable
    public ResourceLocation getRegistryName(ExpandedHammerRecipe recipe) {
        return recipe.getId();
    }
}

