/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.SieveAnimationType;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;

public class TinyHumanModel
extends PlayerModel<LivingEntity> {
    public TinyHumanModel(ModelPart modelPart, boolean smallArms) {
        super(modelPart, smallArms);
    }

    public void animate(AbstractAutoSieveBlockEntity tileEntity, float partialTicks) {
        if (tileEntity.getAnimationType() == SieveAnimationType.MAGIC) {
            if (tileEntity.shouldAnimate()) {
                tileEntity.armAngle += partialTicks * 0.05f;
                float base = (float)Math.toRadians(280.0);
                this.rightArm.xRot = (float)((double)base + Math.sin(tileEntity.armAngle) * (double)0.1f);
                this.leftArm.xRot = (float)((double)base + Math.cos(tileEntity.armAngle) * (double)0.1f);
            } else {
                this.rightArm.xRot = 0.0f;
                this.leftArm.xRot = 0.0f;
            }
        } else if (tileEntity.shouldAnimate()) {
            tileEntity.armAngle += 0.5f * Math.max(1.0f, tileEntity.getSpeedMultiplier() / 4.0f) * partialTicks;
            this.rightArm.xRot = tileEntity.armAngle;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        float scale = 0.0625f;
        poseStack.pushPose();
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.translate(0.0f, 16.0f * scale, 0.0f);
        this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.0f, 24.0f * scale, 0.0f);
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.hat.render(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

