/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.excompressum.block.entity.WoodenCrucibleBlockEntity;
import net.blay09.mods.excompressum.client.ModModels;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class WoodenCrucibleRenderer
implements BlockEntityRenderer<WoodenCrucibleBlockEntity> {
    private final RandomSource random = RandomSource.create();

    public WoodenCrucibleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WoodenCrucibleBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        int solidVolume;
        FluidTank fluidTank;
        BlockState outputState;
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        ItemStack outputStack = blockEntity.getItem(0);
        if (!outputStack.isEmpty() && (outputState = StupidUtils.getStateFromItemStack(outputStack)) != null) {
            poseStack.pushPose();
            poseStack.translate(0.0625f, 0.2f, 0.0625f);
            poseStack.scale(0.875f, 0.75f, 0.875f);
            dispatcher.renderSingleBlock(outputState, poseStack, buffers, combinedLight, combinedOverlay);
            poseStack.popPose();
        }
        if (!(fluidTank = blockEntity.getFluidTank()).isEmpty()) {
            poseStack.pushPose();
            float fillLevel = (float)fluidTank.getAmount() / (float)blockEntity.getFluidTank().getCapacity();
            poseStack.translate(0.0f, fillLevel * 11.0f / 16.0f, 0.0f);
            int color = ((Biome)level.getBiome(blockEntity.getBlockPos()).value()).getWaterColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            dispatcher.getModelRenderer().renderModel(poseStack.last(), buffers.getBuffer(RenderType.translucent()), null, (BakedModel)ModModels.woodenCrucibleLiquid.get(), red, green, blue, combinedLight, combinedOverlay);
            poseStack.popPose();
        }
        if ((solidVolume = blockEntity.getSolidVolume()) > 0) {
            poseStack.pushPose();
            poseStack.translate(0.0625f, 0.251f, 0.0625f);
            poseStack.scale(0.875f, (float)(0.71 * (double)solidVolume / (double)blockEntity.getSolidCapacity()), 0.875f);
            BlockState solidState = Blocks.DARK_OAK_LEAVES.defaultBlockState();
            dispatcher.renderBatched(solidState, blockEntity.getBlockPos(), (BlockAndTintGetter)blockEntity.getLevel(), poseStack, buffers.getBuffer(RenderType.translucent()), false, this.random);
            poseStack.popPose();
        }
    }
}

