/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.AutoHeavySieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.AutoSieveBlockEntity;
import net.blay09.mods.excompressum.client.ModModels;
import net.blay09.mods.excompressum.client.render.model.TinyHumanModel;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;

public class AutoSieveRenderer<T extends AbstractAutoSieveBlockEntity>
implements BlockEntityRenderer<T> {
    private static final RandomSource random = RandomSource.create();
    private final TinyHumanModel tinyHumanModel;
    private final TinyHumanModel tinyHumanModelSlim;
    private final boolean isHeavy;
    public static int cacheKey;
    private int currentCacheKey;
    private BakedModel sieveModel;

    public AutoSieveRenderer(BlockEntityRendererProvider.Context context, boolean isHeavy) {
        this.tinyHumanModel = new TinyHumanModel(context.bakeLayer(ModelLayers.PLAYER), false);
        this.tinyHumanModelSlim = new TinyHumanModel(context.bakeLayer(ModelLayers.PLAYER), true);
        this.isHeavy = isHeavy;
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState contentState;
        ItemStack currentStack;
        BakedModel meshModel;
        Level level = blockEntity.getLevel();
        if (level == null || ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).isUgly()) {
            return;
        }
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        if (this.sieveModel == null || this.currentCacheKey != cacheKey) {
            this.sieveModel = this.isHeavy ? dispatcher.getBlockModel(ModBlocks.heavySieves[0].defaultBlockState()) : (BakedModel)ModModels.sieves.get(0).get();
            this.currentCacheKey = cacheKey;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose(((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getFacing().getRotation());
        poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)-90.0f), 0.0f, 1.0f, 0.0f)));
        poseStack.pushPose();
        poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)-90.0f), 0.0f, 0.0f, 1.0f)));
        poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)90.0f), 0.0f, 1.0f, 0.0f)));
        poseStack.translate(0.0f, -1.2f, 0.25f);
        poseStack.scale(0.75f, 0.75f, 0.75f);
        PlayerSkin skin = this.getPlayerSkin(((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSkinProfile());
        TinyHumanModel playerModel = this.getPlayerModel(skin);
        playerModel.animate((AbstractAutoSieveBlockEntity)((Object)blockEntity), partialTicks);
        playerModel.renderToBuffer(poseStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)skin.texture())), combinedLight, combinedOverlay, -1);
        poseStack.popPose();
        if (((AbstractAutoSieveBlockEntity)((Object)blockEntity)).isWaterlogged()) {
            poseStack.pushPose();
            poseStack.translate(-0.95f, -0.42f, -0.175f);
            float glassScale = 0.35f;
            poseStack.scale(glassScale, glassScale, glassScale);
            dispatcher.renderSingleBlock(Blocks.GLASS.defaultBlockState(), poseStack, buffer, combinedLight, combinedOverlay);
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(-0.25f, 0.0f, -0.5f);
        poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)90.0f), 0.0f, 0.0f, 1.0f)));
        poseStack.translate(-0.2f, -0.1f, 0.0f);
        poseStack.pushPose();
        dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, this.sieveModel, blockEntity.getBlockState(), blockEntity.getBlockPos(), poseStack, buffer.getBuffer(RenderType.solid()), false, random, 0L, Integer.MAX_VALUE);
        poseStack.popPose();
        SieveMeshRegistryEntry mesh = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSieveMesh();
        if (mesh != null && (meshModel = (BakedModel)ModModels.meshes.get(mesh.getModelName()).get()) != null) {
            dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, meshModel, blockEntity.getBlockState(), blockEntity.getBlockPos(), poseStack, buffer.getBuffer(RenderType.translucent()), false, random, 0L, Integer.MAX_VALUE);
        }
        if (!(currentStack = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getCurrentStack()).isEmpty() && (contentState = StupidUtils.getStateFromItemStack(currentStack)) != null) {
            float progress = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getProgress();
            poseStack.pushPose();
            float contentOffset = 0.0625f;
            float meshY = 0.5625f;
            float contentScaleXZ = 0.88f;
            float contentBaseScaleY = 0.5f;
            poseStack.translate(0.0625f, 0.5625f, 0.0625f);
            poseStack.scale(0.88f, 0.5f - progress * 0.5f, 0.88f);
            dispatcher.renderSingleBlock(contentState, poseStack, buffer, combinedLight, combinedOverlay);
            poseStack.popPose();
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    private PlayerSkin getPlayerSkin(@Nullable ResolvableProfile profile) {
        if (profile != null) {
            return Minecraft.getInstance().getSkinManager().getInsecureSkin(profile.gameProfile());
        }
        return DefaultPlayerSkin.get((UUID)UUID.randomUUID());
    }

    private TinyHumanModel getPlayerModel(@Nullable PlayerSkin skin) {
        if (skin != null && "slim".equals(skin.model().id())) {
            return this.tinyHumanModelSlim;
        }
        return this.tinyHumanModel;
    }

    public static AutoSieveRenderer<AutoSieveBlockEntity> normal(BlockEntityRendererProvider.Context context) {
        return new AutoSieveRenderer<AutoSieveBlockEntity>(context, false);
    }

    public static AutoSieveRenderer<AutoHeavySieveBlockEntity> heavy(BlockEntityRendererProvider.Context context) {
        return new AutoSieveRenderer<AutoHeavySieveBlockEntity>(context, true);
    }
}

