/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.blay09.mods.excompressum.block.entity.AutoHammerBlockEntity;
import net.blay09.mods.excompressum.client.render.BlockRenderUtils;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;

public class AutoHammerRenderer
implements BlockEntityRenderer<AutoHammerBlockEntity> {
    private final boolean isCompressed;
    private ItemStack hammerItemStack = ItemStack.EMPTY;

    public AutoHammerRenderer(BlockEntityRendererProvider.Context context, boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    public void render(AutoHammerBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        BlockState contentState;
        ItemStack secondHammer;
        Level level = tileEntity.getLevel();
        if (level == null) {
            return;
        }
        if (tileEntity.isUgly()) {
            return;
        }
        if (this.hammerItemStack.isEmpty()) {
            if (this.isCompressed) {
                this.hammerItemStack = new ItemStack((ItemLike)ModItems.compressedDiamondHammer);
            } else {
                Iterator iterator = BuiltInRegistries.ITEM.getTagOrEmpty(ModItemTags.DIAMOND_HAMMERS).iterator();
                if (iterator.hasNext()) {
                    Holder itemHolder = (Holder)iterator.next();
                    this.hammerItemStack = new ItemStack((ItemLike)itemHolder.value());
                }
                if (this.hammerItemStack.isEmpty()) {
                    this.hammerItemStack = new ItemStack((ItemLike)Items.COD);
                }
            }
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose(tileEntity.getFacing().getRotation());
        poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)-90.0f), 0.0f, 1.0f, 0.0f)));
        if (tileEntity.shouldAnimate()) {
            tileEntity.hammerAngle += 0.4f * partialTicks;
        }
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.pushPose();
        poseStack.translate(-0.7f, -0.3f, 0.0f);
        poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)(Math.sin((float)tileEntity.hammerAngle) * 30.0f)), 0.0f, 0.0f, 1.0f)));
        poseStack.translate(-0.4f, 0.2f, 0.0f);
        itemRenderer.renderStatic(this.hammerItemStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffers, level, 0);
        poseStack.popPose();
        ItemStack firstHammer = tileEntity.getUpgradeStack(0);
        if (!firstHammer.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.7f, -0.3f, 0.0f);
            poseStack.translate(0.0f, 0.1f, 0.33f);
            poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)10.0f), 0.0f, 1.0f, 0.0f)));
            poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)(Math.sin((float)(tileEntity.hammerAngle - 8.0f)) * 30.0f)), 0.0f, 0.0f, 1.0f)));
            poseStack.translate(-0.4f, 0.2f, 0.0f);
            itemRenderer.renderStatic(firstHammer, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffers, level, 0);
            poseStack.popPose();
        }
        if (!(secondHammer = tileEntity.getUpgradeStack(1)).isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.7f, -0.3f, 0.0f);
            poseStack.translate(0.0f, 0.1f, -0.33f);
            poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)-10.0f), 0.0f, 1.0f, 0.0f)));
            poseStack.mulPose(new Quaternionf(new AxisAngle4f(Math.toRadians((float)(Math.sin((float)(tileEntity.hammerAngle + 8.0f)) * 30.0f)), 0.0f, 0.0f, 1.0f)));
            poseStack.translate(-0.4f, 0.2f, 0.0f);
            itemRenderer.renderStatic(secondHammer, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffers, level, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
        ItemStack currentStack = tileEntity.getCurrentStack();
        if (!currentStack.isEmpty() && !(contentState = StupidUtils.getStateFromItemStack(currentStack)).isAir()) {
            poseStack.pushPose();
            poseStack.translate((double)-0.4625f, (double)-0.04f, -0.2);
            poseStack.scale(0.4f, 0.4f, 0.4f);
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            dispatcher.renderSingleBlock(contentState, poseStack, buffers, combinedLight, combinedOverlay);
            if (tileEntity.getProgress() > 0.0f) {
                int blockDamage = Math.min((int)9, (int)((int)(tileEntity.getProgress() * 9.0f)));
                BlockRenderUtils.renderBlockBreak(contentState, poseStack, buffers, combinedLight, combinedOverlay, blockDamage + 1);
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public static <T extends AutoHammerBlockEntity> BlockEntityRenderer<T> normal(BlockEntityRendererProvider.Context context) {
        return new AutoHammerRenderer(context, false);
    }

    public static <T extends AutoHammerBlockEntity> BlockEntityRenderer<T> compressed(BlockEntityRendererProvider.Context context) {
        return new AutoHammerRenderer(context, true);
    }
}

