/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.menu.AutoSieveMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AutoSieveScreen
extends AbstractContainerScreen<AutoSieveMenu> {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"textures/gui/auto_sieve.png");

    public AutoSieveScreen(AutoSieveMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        AbstractAutoSieveBlockEntity tileEntity = ((AutoSieveMenu)this.menu).getAutoSieve();
        if (tileEntity.isProcessing()) {
            guiGraphics.blit(texture, this.leftPos + 32, this.topPos + 36, 176, 0, (int)(tileEntity.getProgress() * 15.0f), 14);
        }
        if (tileEntity.isDisabledByRedstone()) {
            guiGraphics.blit(texture, this.leftPos + 34, this.topPos + 52, 176, 14, 15, 16);
        }
        this.renderEnergyBar(guiGraphics);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        AbstractAutoSieveBlockEntity blockEntity = ((AutoSieveMenu)this.menu).getAutoSieve();
        if (blockEntity.getMeshStack().isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 300.0f);
            guiGraphics.fill(58, 16, 144, 71, -1728053248);
            String string = I18n.get((String)"gui.excompressum.auto_sieve.no_mesh", (Object[])new Object[0]);
            Objects.requireNonNull(this.font);
            guiGraphics.drawCenteredString(this.font, string, 101, 43 - 9 / 2, -1);
            poseStack.popPose();
        } else if (!blockEntity.isCorrectSieveMesh()) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 300.0f);
            guiGraphics.fill(58, 16, 144, 71, -1728053248);
            String string = I18n.get((String)"gui.excompressum.auto_sieve.incorrect_mesh", (Object[])new Object[0]);
            Objects.requireNonNull(this.font);
            guiGraphics.drawCenteredString(this.font, string, 101, 43 - 9 / 2, -1);
            poseStack.popPose();
        }
        this.renderPowerTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderEnergyBar(GuiGraphics guiGraphics) {
        AbstractAutoSieveBlockEntity tileEntity = ((AutoSieveMenu)this.menu).getAutoSieve();
        float energyPercentage = tileEntity.getEnergyPercentage();
        guiGraphics.blit(texture, this.leftPos + 152, this.topPos + 8 + (70 - (int)(energyPercentage * 70.0f)), 191, 0, 16, (int)(energyPercentage * 70.0f));
    }

    protected void renderPowerTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (mouseX >= this.leftPos + 152 && mouseX <= this.leftPos + 167 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 77) {
            AbstractAutoSieveBlockEntity blockEntity = ((AutoSieveMenu)this.menu).getAutoSieve();
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"tooltip.excompressum.energyStored", (Object[])new Object[]{blockEntity.getEnergyStored()}));
            tooltip.add(Component.translatable((String)"tooltip.excompressum.consumingEnergy", (Object[])new Object[]{blockEntity.getEffectiveEnergy()}));
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltip, mouseX - this.leftPos, mouseY - this.topPos);
        }
    }
}

