/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.blay09.mods.excompressum.block.entity.AutoCompressorBlockEntity;
import net.blay09.mods.excompressum.menu.AutoCompressorMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AutoCompressorScreen
extends AbstractContainerScreen<AutoCompressorMenu> {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"textures/gui/auto_compressor.png");

    public AutoCompressorScreen(AutoCompressorMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        AutoCompressorBlockEntity tileEntity = ((AutoCompressorMenu)this.menu).getAutoCompressor();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (tileEntity.isProcessing()) {
            guiGraphics.blit(texture, this.leftPos + 69, this.topPos + 9, 176, 0, (int)(tileEntity.getProgress() * 15.0f), 14);
            guiGraphics.blit(texture, this.leftPos + 69, this.topPos + 36, 176, 0, (int)(tileEntity.getProgress() * 15.0f), 14);
            guiGraphics.blit(texture, this.leftPos + 69, this.topPos + 63, 176, 0, (int)(tileEntity.getProgress() * 15.0f), 14);
        }
        if (tileEntity.isDisabledByRedstone()) {
            guiGraphics.blit(texture, this.leftPos + 72, this.topPos + 24, 176, 14, 15, 16);
            guiGraphics.blit(texture, this.leftPos + 72, this.topPos + 51, 176, 14, 15, 16);
        }
        float energyPercentage = tileEntity.getEnergyPercentage();
        guiGraphics.blit(texture, this.leftPos + 152, this.topPos + 8 + (70 - (int)(energyPercentage * 70.0f)), 191, 0, 16, (int)(energyPercentage * 70.0f));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (mouseX >= this.leftPos + 152 && mouseX <= this.leftPos + 167 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 77) {
            AutoCompressorBlockEntity blockEntity = ((AutoCompressorMenu)this.menu).getAutoCompressor();
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"tooltip.excompressum.energyStored", (Object[])new Object[]{blockEntity.getEnergyStorage().getEnergy()}));
            tooltip.add(Component.translatable((String)"tooltip.excompressum.consumingEnergy", (Object[])new Object[]{blockEntity.getEffectiveEnergy()}));
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltip, mouseX - this.leftPos, mouseY - this.topPos);
        }
    }
}

