/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client;

import com.google.common.collect.Sets;
import java.util.Set;
import net.blay09.mods.excompressum.CommonProxy;
import net.blay09.mods.excompressum.client.render.HammeringParticle;
import net.blay09.mods.excompressum.client.render.SievingParticle;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClientProxy
extends CommonProxy {
    private final Set<ResolvableProfile> skinRequested = Sets.newHashSet();

    @Override
    public void preloadSkin(ResolvableProfile profile) {
        if (!this.skinRequested.contains(profile)) {
            Minecraft.getInstance().getSkinManager().getOrLoad(profile.gameProfile());
            this.skinRequested.add(profile);
        }
    }

    @Override
    public void spawnCrushParticles(Level level, BlockPos pos, BlockState particleState) {
        if (!ExCompressumConfig.getActive().client.disableParticles) {
            for (int i = 0; i < 10; ++i) {
                Minecraft.getInstance().particleEngine.add((Particle)new HammeringParticle((ClientLevel)level, pos, (float)pos.getX() + 0.7f, (float)pos.getY() + 0.3f, (float)pos.getZ() + 0.5f, (-level.random.nextDouble() + (double)0.2f) / 9.0, 0.2f, (level.random.nextDouble() - 0.5) / 9.0, particleState));
            }
        }
    }

    @Override
    public void spawnAutoSieveParticles(Level level, BlockPos pos, BlockState emitterState, BlockState particleState, int particleCount) {
        float offsetX = 0.0f;
        float offsetZ = 0.0f;
        if (emitterState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            switch ((Direction)emitterState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                case WEST: {
                    offsetZ -= 0.125f;
                    break;
                }
                case EAST: {
                    offsetZ += 0.125f;
                    break;
                }
                case NORTH: {
                    offsetX += 0.125f;
                    break;
                }
                case SOUTH: {
                    offsetX -= 0.125f;
                    break;
                }
            }
        }
        this.spawnSieveParticles(level, pos, particleState, particleCount, new Vec3((double)offsetX, (double)0.2f, (double)offsetZ), 0.5f);
    }

    @Override
    public void spawnHeavySieveParticles(Level level, BlockPos pos, BlockState particleState, int particleCount) {
        this.spawnSieveParticles(level, pos, particleState, particleCount, new Vec3(0.0, (double)0.4f, 0.0), 1.0f);
    }

    private void spawnSieveParticles(Level level, BlockPos pos, BlockState particleState, int particleCount, Vec3 particleOffset, float scale) {
        if (ExCompressumConfig.getActive().client.disableParticles) {
            return;
        }
        ParticleStatus particleStatus = (ParticleStatus)Minecraft.getInstance().options.particles().get();
        if (particleStatus == ParticleStatus.MINIMAL) {
            return;
        }
        int actualParticleCount = particleCount;
        if (particleStatus == ParticleStatus.DECREASED) {
            float half = (float)actualParticleCount / 2.0f;
            if (half < 1.0f && Math.random() <= 0.5) {
                return;
            }
            actualParticleCount = (int)Math.ceil(half);
        }
        for (int i = 0; i < actualParticleCount; ++i) {
            double spread = 0.8 * (double)scale;
            double min = 0.4 * (double)scale;
            float particleScale = 0.25f * scale;
            double particleX = 0.5 + particleOffset.x() + (double)level.random.nextFloat() * spread - min;
            double particleY = particleOffset.y();
            double particleZ = 0.5 + particleOffset.z() + (double)level.random.nextFloat() * spread - min;
            Minecraft.getInstance().particleEngine.add((Particle)new SievingParticle((ClientLevel)level, pos, particleX, particleY, particleZ, particleScale, particleState));
        }
    }

    @Override
    @Deprecated
    public RecipeManager getRecipeManager(@Nullable Level level) {
        if (level == null) {
            level = Minecraft.getInstance().level;
        }
        if (level == null) {
            return new RecipeManager((HolderLookup.Provider)level.registryAccess());
        }
        return level.getRecipeManager();
    }
}

