/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ImplementedContainer;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRecipe;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class WoodenCrucibleBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider,
ImplementedContainer {
    private static final int RAIN_FILL_INTERVAL = 20;
    private static final int MELT_INTERVAL = 20;
    private static final int RAIN_FILL_SPEED = 8;
    private static final int SYNC_INTERVAL = 10;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final FluidTank fluidTank = new FluidTank(1999){

        public int fill(Fluid fluid, int maxFill, boolean simulate) {
            int result = super.fill(fluid, maxFill, simulate);
            if (this.getAmount() > 1000) {
                this.setAmount(1000);
            }
            return result;
        }

        public boolean canFill(Fluid fluid) {
            return ((ItemStack)WoodenCrucibleBlockEntity.this.items.get(0)).isEmpty() && WoodenCrucibleBlockEntity.this.isValidFluid(fluid);
        }

        public int getCapacity() {
            return 1000;
        }

        public void setChanged() {
            WoodenCrucibleBlockEntity.this.setChanged();
            WoodenCrucibleBlockEntity.this.isDirty = true;
        }
    };
    private int ticksSinceSync;
    private boolean isDirty;
    private int ticksSinceRain;
    private int ticksSinceMelt;
    private Fluid currentTargetFluid;
    private int solidVolume;

    private boolean isValidFluid(Fluid fluid) {
        return fluid.isSame((Fluid)Fluids.WATER);
    }

    public WoodenCrucibleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.woodenCrucible.get(), pos, state);
    }

    public boolean addItem(ItemStack itemStack, boolean isAutomated, boolean simulate) {
        if (this.fluidTank.getAmount() >= 1000 && itemStack.is(ModItemTags.DUSTS)) {
            if (!simulate) {
                this.items.set(0, (Object)new ItemStack((ItemLike)Blocks.CLAY));
                this.fluidTank.setFluid(Fluids.EMPTY, 0);
                this.sync();
            }
            return true;
        }
        WoodenCrucibleRecipe recipe = ExRegistries.getWoodenCrucibleRegistry().getRecipe(this.level, itemStack);
        if (recipe != null && (this.fluidTank.isEmpty() || recipe.matchesFluid(this.fluidTank.getFluid()))) {
            int capacityLeft = this.fluidTank.getCapacity() - this.fluidTank.getAmount() - this.solidVolume;
            if (isAutomated && capacityLeft >= recipe.getAmount() || !isAutomated && capacityLeft > 0) {
                if (!simulate) {
                    this.currentTargetFluid = recipe.getFluid();
                    this.solidVolume += Math.min(capacityLeft, recipe.getAmount());
                    this.sync();
                }
                return true;
            }
        }
        return false;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WoodenCrucibleBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void serverTick() {
        if (this.level.getLevelData().isRaining() && this.level.canSeeSkyFromBelowWater(this.worldPosition) && ((Biome)this.level.getBiome(this.worldPosition).value()).hasPrecipitation()) {
            ++this.ticksSinceRain;
            if (this.ticksSinceRain >= 20) {
                this.fluidTank.fill((Fluid)Fluids.WATER, 8, false);
                this.ticksSinceRain = 0;
            }
        }
        if (this.currentTargetFluid != null) {
            ++this.ticksSinceMelt;
            if (this.ticksSinceMelt >= 20 && this.fluidTank.getAmount() < this.fluidTank.getCapacity()) {
                int amount = Math.min(ExCompressumConfig.getActive().automation.woodenCrucibleSpeed, this.solidVolume);
                this.fluidTank.fill(this.currentTargetFluid, amount, false);
                this.solidVolume = Math.max(0, this.solidVolume - amount);
                this.ticksSinceMelt = 0;
                this.isDirty = true;
            }
        }
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 10) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.solidVolume = tagCompound.getInt("SolidVolume");
        this.fluidTank.deserialize(tagCompound.getCompound("FluidTank"));
        ContainerHelper.loadAllItems((CompoundTag)tagCompound, this.items, (HolderLookup.Provider)provider);
        if (tagCompound.contains("TargetFluid")) {
            this.currentTargetFluid = Balm.getRegistries().getFluid(ResourceLocation.parse((String)tagCompound.getString("TargetFluid")));
        }
    }

    public void saveAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        if (this.currentTargetFluid != null) {
            ResourceLocation fluidId = Balm.getRegistries().getKey(this.currentTargetFluid);
            tagCompound.putString("TargetFluid", Objects.toString(fluidId));
        }
        tagCompound.putInt("SolidVolume", this.solidVolume);
        tagCompound.put("FluidTank", (Tag)this.fluidTank.serialize());
        ContainerHelper.saveAllItems((CompoundTag)tagCompound, this.items, (HolderLookup.Provider)provider);
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public int getSolidVolume() {
        return this.solidVolume;
    }

    public int getSolidCapacity() {
        return this.fluidTank.getCapacity();
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }
}

