/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.List;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.excompressum.CommonProxy;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;

public class HeavySieveBlockEntity
extends BalmBlockEntity {
    private static final float PROCESSING_INTERVAL = 0.075f;
    private static final int UPDATE_INTERVAL = 5;
    private static final int PARTICLE_TICKS = 20;
    private static final float EFFICIENCY_BOOST = 0.25f;
    private ItemStack meshStack = ItemStack.EMPTY;
    private ItemStack currentStack = ItemStack.EMPTY;
    private float progress;
    private int clicksSinceSecond;
    private boolean isDirty;
    private int ticksSinceSync;
    private int ticksSinceSecond;
    private int particleTicks;
    private int particleCount;

    public HeavySieveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.heavySieve.get(), pos, state);
    }

    public boolean addSiftable(Player player, ItemStack itemStack) {
        if (!this.currentStack.isEmpty() || this.meshStack.isEmpty() || !ExRegistries.getHeavySieveRegistry().isSiftable(this.level, this.getBlockState(), itemStack, this.getSieveMesh())) {
            return false;
        }
        this.currentStack = player.getAbilities().instabuild ? ContainerUtils.copyStackWithSize((ItemStack)itemStack, (int)1) : itemStack.split(1);
        this.progress = 0.0f;
        this.sync();
        return true;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, HeavySieveBlockEntity blockEntity) {
        blockEntity.clientTick();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HeavySieveBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void clientTick() {
        if (this.particleTicks > 0) {
            BlockState state;
            --this.particleTicks;
            if (this.particleTicks <= 0) {
                this.particleCount = 0;
            }
            if (!this.currentStack.isEmpty() && !(state = StupidUtils.getStateFromItemStack(this.currentStack)).isAir()) {
                ((CommonProxy)ExCompressum.proxy.get()).spawnHeavySieveParticles(this.level, this.worldPosition, state, this.particleCount);
            }
        }
    }

    public void serverTick() {
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 5) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
        ++this.ticksSinceSecond;
        if (this.ticksSinceSecond >= 20) {
            this.clicksSinceSecond = 0;
            this.ticksSinceSecond = 0;
        }
    }

    public boolean processContents(Player player) {
        if (this.currentStack.isEmpty() || this.meshStack.isEmpty()) {
            return false;
        }
        if (player.getAbilities().instabuild) {
            this.progress = 1.0f;
        } else {
            ++this.clicksSinceSecond;
            if (this.clicksSinceSecond <= ExCompressumConfig.getActive().automation.heavySieveClicksPerSecond) {
                int efficiency = ExNihilo.getInstance().getMeshEfficiency(this.meshStack);
                this.progress = Math.min(1.0f, this.progress + 0.075f * (1.0f + (float)efficiency * 0.25f));
            }
        }
        if (this.progress >= 1.0f) {
            this.particleCount = 0;
            if (!this.level.isClientSide) {
                SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                if (sieveMesh != null) {
                    LootContext lootContext = LootTableUtils.buildLootContext((ServerLevel)this.level, this.currentStack);
                    List<ItemStack> rewards = HeavySieveRegistry.rollSieveRewards(this.level, lootContext, this.getBlockState(), sieveMesh, this.currentStack);
                    for (ItemStack itemStack : rewards) {
                        this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5, itemStack));
                    }
                } else {
                    this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5, this.currentStack));
                }
                this.currentStack = ItemStack.EMPTY;
                if (ExNihilo.getInstance().doMeshesHaveDurability() && sieveMesh != null) {
                    if (!sieveMesh.isHeavy()) {
                        this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 0.5f, 2.5f);
                        this.meshStack = ItemStack.EMPTY;
                    } else {
                        this.meshStack.hurtAndBreak(1, (ServerLevel)this.level, (ServerPlayer)player, it -> {
                            this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 0.5f, 2.5f);
                            this.meshStack = ItemStack.EMPTY;
                        });
                    }
                }
                this.progress = 0.0f;
                this.sync();
            }
        }
        this.setChanged();
        this.particleTicks = 20;
        ++this.particleCount;
        this.isDirty = true;
        return true;
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.currentStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tagCompound.getCompound("Content"));
        this.meshStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tagCompound.getCompound("Mesh"));
        this.progress = tagCompound.getFloat("Progress");
        this.particleTicks = tagCompound.getInt("ParticleTicks");
        this.particleCount = tagCompound.getInt("ParticleCount");
    }

    public void saveAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        tagCompound.put("Content", this.currentStack.saveOptional(provider));
        tagCompound.put("Mesh", this.meshStack.saveOptional(provider));
        tagCompound.putFloat("Progress", this.progress);
        tagCompound.putInt("ParticleTicks", this.particleTicks);
        tagCompound.putInt("ParticleCount", this.particleCount);
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public ItemStack getMeshStack() {
        return this.meshStack;
    }

    public float getProgress() {
        return this.progress;
    }

    @Nullable
    public SieveMeshRegistryEntry getSieveMesh() {
        if (!this.meshStack.isEmpty()) {
            return SieveMeshRegistry.getEntry(this.meshStack);
        }
        return null;
    }

    public void setMeshStack(ItemStack meshStack) {
        this.meshStack = meshStack;
        this.setChanged();
        this.sync();
    }
}

