/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.DelegateContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.excompressum.block.entity.AbstractBaseBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.component.ModComponents;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.menu.AutoCompressorMenu;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AutoCompressorBlockEntity
extends AbstractBaseBlockEntity
implements BalmMenuProvider<BlockPos>,
BalmEnergyStorageProvider,
BalmContainerProvider {
    private final EnergyStorage energyStorage = new EnergyStorage(this, 32000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                this.setChanged();
            }
            return super.fill(maxReceive, simulate);
        }
    };
    private final Multiset<CompressedRecipe> inputItems = HashMultiset.create();
    private final DefaultContainer backingContainer = new DefaultContainer(24);
    private final SubContainer inputSlots = new SubContainer((Container)this.backingContainer, 0, 12);
    private final SubContainer outputSlots = new SubContainer((Container)this.backingContainer, 12, 24);
    private final Container container = new DelegateContainer((Container)this.backingContainer){

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            return AutoCompressorBlockEntity.this.inputSlots.containsOuterSlot(slot) && ExRegistries.getCompressedRecipeRegistry().getRecipe(itemStack) != null;
        }

        public int[] getSlotsForFace(Direction direction) {
            if (direction == Direction.DOWN) {
                return AutoCompressorBlockEntity.this.outputSlots.getOuterSlotsForFace(direction);
            }
            return AutoCompressorBlockEntity.this.inputSlots.getOuterSlotsForFace(direction);
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack itemStack, Direction direction) {
            return AutoCompressorBlockEntity.this.outputSlots.containsOuterSlot(slot);
        }
    };
    private final List<ItemStack> overflowBuffer = new ArrayList<ItemStack>();
    private final ContainerData containerData = new ContainerData(){

        public int get(int id) {
            if (id == 0) {
                return (int)(100.0f * AutoCompressorBlockEntity.this.getProgress());
            }
            if (id == 1) {
                return AutoCompressorBlockEntity.this.getEnergyStorage().getEnergy();
            }
            if (id == 2) {
                return AutoCompressorBlockEntity.this.isDisabledByRedstone() ? 1 : 0;
            }
            return 0;
        }

        public void set(int id, int value) {
            if (id == 0) {
                AutoCompressorBlockEntity.this.setProgress((float)value / 100.0f);
            } else if (id == 1) {
                AutoCompressorBlockEntity.this.getEnergyStorage().setEnergy(value);
            } else if (id == 2) {
                AutoCompressorBlockEntity.this.setDisabledByRedstone(value == 1);
            }
        }

        public int getCount() {
            return 3;
        }
    };
    private NonNullList<ItemStack> currentBuffer = NonNullList.create();
    private CompressedRecipe currentRecipe = null;
    private float progress;
    private boolean isDisabledByRedstone;

    public AutoCompressorBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.autoCompressor.get(), pos, state);
    }

    public AutoCompressorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean shouldCompress(Multiset<CompressedRecipe> inputItems, CompressedRecipe compressedRecipe) {
        return inputItems.count((Object)compressedRecipe) >= compressedRecipe.getCount();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AutoCompressorBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void serverTick() {
        int effectiveEnergy = this.getEffectiveEnergy();
        if (!this.isDisabledByRedstone() && this.overflowBuffer.isEmpty() && this.energyStorage.getEnergy() > effectiveEnergy) {
            if (this.currentRecipe == null) {
                this.inputItems.clear();
                for (int i = 0; i < this.inputSlots.getContainerSize(); ++i) {
                    CompressedRecipe compressedRecipe;
                    ItemStack slotStack = this.inputSlots.getItem(i);
                    if (slotStack.isEmpty() || (compressedRecipe = ExRegistries.getCompressedRecipeRegistry().getRecipe(slotStack)) == null) continue;
                    this.inputItems.add((Object)compressedRecipe, slotStack.getCount());
                }
                for (CompressedRecipe compressedRecipe : this.inputItems.elementSet()) {
                    Ingredient ingredient = compressedRecipe.getIngredient();
                    if (!this.shouldCompress(this.inputItems, compressedRecipe)) continue;
                    int space = 0;
                    for (int i = 0; i < this.outputSlots.getContainerSize(); ++i) {
                        ItemStack slotStack = this.outputSlots.getItem(i);
                        if (slotStack.isEmpty()) {
                            space = 64;
                        } else if (this.isItemEqualWildcard(slotStack, compressedRecipe.getResultStack())) {
                            space += slotStack.getMaxStackSize() - slotStack.getCount();
                        }
                        if (space >= compressedRecipe.getResultStack().getCount()) break;
                    }
                    if (space < compressedRecipe.getResultStack().getCount()) continue;
                    int count = compressedRecipe.getCount();
                    for (int i = 0; i < this.inputSlots.getContainerSize(); ++i) {
                        ItemStack slotStack = this.inputSlots.getItem(i);
                        if (slotStack.isEmpty() || !ingredient.test(slotStack)) continue;
                        if (slotStack.getCount() >= count) {
                            this.currentBuffer.add((Object)slotStack.split(count));
                            if (slotStack.isEmpty()) {
                                this.inputSlots.setItem(i, ItemStack.EMPTY);
                            }
                            count = 0;
                            break;
                        }
                        this.currentBuffer.add((Object)slotStack.copy());
                        count -= slotStack.getCount();
                        this.inputSlots.setItem(i, ItemStack.EMPTY);
                    }
                    if (count <= 0) {
                        this.currentRecipe = compressedRecipe;
                        this.progress = 0.0f;
                    }
                    break;
                }
            } else {
                this.energyStorage.drain(effectiveEnergy, false);
                this.progress = Math.min(1.0f, this.progress + this.getEffectiveSpeed());
                if (this.progress >= 1.0f) {
                    ItemStack resultStack;
                    CompressedRecipe compressedRecipe;
                    if (!this.level.isClientSide && (compressedRecipe = this.currentRecipe) != null && !this.addItemToOutput(resultStack = compressedRecipe.getResultStack().copy())) {
                        this.overflowBuffer.add(resultStack);
                    }
                    this.currentBuffer.clear();
                    this.currentRecipe = null;
                    this.progress = 0.0f;
                }
            }
        } else if (!this.overflowBuffer.isEmpty() && this.addItemToOutput(this.overflowBuffer.get(0))) {
            this.overflowBuffer.remove(0);
        }
    }

    private boolean isItemEqualWildcard(ItemStack itemStack, ItemStack otherStack) {
        return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)otherStack) && (ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)otherStack) || itemStack.getItem() == otherStack.getItem());
    }

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.getContainerSize(); ++i) {
            ItemStack slotStack = this.outputSlots.getItem(i);
            if (slotStack.isEmpty()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.getCount() + itemStack.getCount() > slotStack.getMaxStackSize() || !this.isItemEqualWildcard(slotStack, itemStack)) continue;
            slotStack.grow(itemStack.getCount());
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.setItem(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ExCompressumConfig.getActive().automation.autoCompressorEnergy;
    }

    public float getEffectiveSpeed() {
        return (float)ExCompressumConfig.getActive().automation.autoCompressorSpeed;
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        ItemStack itemStack;
        if (tagCompound.contains("CurrentRecipeResult") && !(itemStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tagCompound.getCompound("CurrentRecipeResult"))).isEmpty()) {
            this.currentRecipe = new CompressedRecipe(Ingredient.EMPTY, 0, itemStack);
        }
        this.isDisabledByRedstone = tagCompound.getBoolean("IsDisabledByRedstone");
        this.progress = tagCompound.getFloat("Progress");
        this.backingContainer.deserialize(tagCompound.getCompound("ItemHandler"), provider);
        this.energyStorage.deserialize(tagCompound.get("EnergyStorage"));
        this.overflowBuffer.clear();
        for (Tag overflowItem : tagCompound.getList("OverflowBuffer", 10)) {
            ItemStack.parse((HolderLookup.Provider)provider, (Tag)overflowItem).ifPresent(this.overflowBuffer::add);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (this.currentRecipe != null) {
            tag.put("CurrentRecipeResult", this.currentRecipe.getResultStack().save(provider));
        }
        tag.putBoolean("IsDisabledByRedstone", this.isDisabledByRedstone);
        tag.putFloat("Progress", this.progress);
        tag.put("ItemHandler", (Tag)this.backingContainer.serialize(provider));
        tag.put("EnergyStorage", (Tag)this.energyStorage.serialize());
        ListTag overflowList = new ListTag();
        for (ItemStack itemStack : this.overflowBuffer) {
            overflowList.add((Object)itemStack.save(provider));
        }
        tag.put("OverflowBuffer", (Tag)overflowList);
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public float getEnergyPercentage() {
        return (float)this.energyStorage.getEnergy() / (float)this.energyStorage.getCapacity();
    }

    public NonNullList<ItemStack> getCurrentBuffer() {
        return this.currentBuffer;
    }

    public Container getBackingContainer() {
        return this.backingContainer;
    }

    public Container getContainer() {
        return this.container;
    }

    public Container getContainer(Direction side) {
        if (side == Direction.DOWN) {
            return this.outputSlots;
        }
        return super.getContainer(side);
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public boolean isDisabledByRedstone() {
        return this.isDisabledByRedstone;
    }

    public void setDisabledByRedstone(boolean disabledByRedstone) {
        this.isDisabledByRedstone = disabledByRedstone;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.excompressum.auto_compressor");
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new AutoCompressorMenu(windowId, inv, this);
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set((DataComponentType)ModComponents.energy.get(), (Object)this.energyStorage.getEnergy());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        Integer energyComponent = (Integer)input.get((DataComponentType)ModComponents.energy.get());
        if (energyComponent != null) {
            this.energyStorage.setEnergy(energyComponent.intValue());
        }
    }

    public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
        return this.worldPosition;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
        return BlockPos.STREAM_CODEC.cast();
    }
}

